<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Task StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:unsignedInt
 * @subpackage Structs
 */
class Task extends CalendarItem
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The dueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The assignedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $assignedDate;
    /**
     * The taskPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taskPriority;
    /**
     * The completed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $completed;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Timezone
     */
    public $timezone;
    /**
     * Constructor method for Task
     * @uses Task::setStartDate()
     * @uses Task::setDueDate()
     * @uses Task::setAssignedDate()
     * @uses Task::setTaskPriority()
     * @uses Task::setCompleted()
     * @uses Task::setTimezone()
     * @param string $startDate
     * @param string $dueDate
     * @param string $assignedDate
     * @param string $taskPriority
     * @param bool $completed
     * @param \StructType\Timezone $timezone
     */
    public function __construct($startDate = null, $dueDate = null, $assignedDate = null, $taskPriority = null, $completed = null, \StructType\Timezone $timezone = null)
    {
        $this
            ->setStartDate($startDate)
            ->setDueDate($dueDate)
            ->setAssignedDate($assignedDate)
            ->setTaskPriority($taskPriority)
            ->setCompleted($completed)
            ->setTimezone($timezone);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Task
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Task
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get assignedDate value
     * @return string|null
     */
    public function getAssignedDate()
    {
        return $this->assignedDate;
    }
    /**
     * Set assignedDate value
     * @param string $assignedDate
     * @return \StructType\Task
     */
    public function setAssignedDate($assignedDate = null)
    {
        // validation for constraint: string
        if (!is_null($assignedDate) && !is_string($assignedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignedDate)), __LINE__);
        }
        $this->assignedDate = $assignedDate;
        return $this;
    }
    /**
     * Get taskPriority value
     * @return string|null
     */
    public function getTaskPriority()
    {
        return $this->taskPriority;
    }
    /**
     * Set taskPriority value
     * @param string $taskPriority
     * @return \StructType\Task
     */
    public function setTaskPriority($taskPriority = null)
    {
        // validation for constraint: string
        if (!is_null($taskPriority) && !is_string($taskPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taskPriority)), __LINE__);
        }
        $this->taskPriority = $taskPriority;
        return $this;
    }
    /**
     * Get completed value
     * @return bool|null
     */
    public function getCompleted()
    {
        return $this->completed;
    }
    /**
     * Set completed value
     * @param bool $completed
     * @return \StructType\Task
     */
    public function setCompleted($completed = null)
    {
        // validation for constraint: boolean
        if (!is_null($completed) && !is_bool($completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($completed)), __LINE__);
        }
        $this->completed = $completed;
        return $this;
    }
    /**
     * Get timezone value
     * @return \StructType\Timezone|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param \StructType\Timezone $timezone
     * @return \StructType\Task
     */
    public function setTimezone(\StructType\Timezone $timezone = null)
    {
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Task
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
