<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemFolder StructType
 * @subpackage Structs
 */
class SystemFolder extends Folder
{
    /**
     * The isSystemFolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSystemFolder;
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The acl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FolderACL
     */
    public $acl;
    /**
     * The isSharedByMe
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSharedByMe;
    /**
     * Constructor method for SystemFolder
     * @uses SystemFolder::setIsSystemFolder()
     * @uses SystemFolder::setFolderType()
     * @uses SystemFolder::setAcl()
     * @uses SystemFolder::setIsSharedByMe()
     * @param bool $isSystemFolder
     * @param string $folderType
     * @param \StructType\FolderACL $acl
     * @param bool $isSharedByMe
     */
    public function __construct($isSystemFolder = null, $folderType = null, \StructType\FolderACL $acl = null, $isSharedByMe = null)
    {
        $this
            ->setIsSystemFolder($isSystemFolder)
            ->setFolderType($folderType)
            ->setAcl($acl)
            ->setIsSharedByMe($isSharedByMe);
    }
    /**
     * Get isSystemFolder value
     * @return bool|null
     */
    public function getIsSystemFolder()
    {
        return $this->isSystemFolder;
    }
    /**
     * Set isSystemFolder value
     * @param bool $isSystemFolder
     * @return \StructType\SystemFolder
     */
    public function setIsSystemFolder($isSystemFolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystemFolder) && !is_bool($isSystemFolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSystemFolder)), __LINE__);
        }
        $this->isSystemFolder = $isSystemFolder;
        return $this;
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderType::valueIsValid()
     * @uses \EnumType\FolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\SystemFolder
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\FolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get acl value
     * @return \StructType\FolderACL|null
     */
    public function getAcl()
    {
        return $this->acl;
    }
    /**
     * Set acl value
     * @param \StructType\FolderACL $acl
     * @return \StructType\SystemFolder
     */
    public function setAcl(\StructType\FolderACL $acl = null)
    {
        $this->acl = $acl;
        return $this;
    }
    /**
     * Get isSharedByMe value
     * @return bool|null
     */
    public function getIsSharedByMe()
    {
        return $this->isSharedByMe;
    }
    /**
     * Set isSharedByMe value
     * @param bool $isSharedByMe
     * @return \StructType\SystemFolder
     */
    public function setIsSharedByMe($isSharedByMe = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSharedByMe) && !is_bool($isSharedByMe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSharedByMe)), __LINE__);
        }
        $this->isSharedByMe = $isSharedByMe;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SystemFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
