<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscribe StructType
 * @subpackage Structs
 */
class Subscribe extends AbstractStructBase
{
    /**
     * The alarm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $alarm;
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $notification;
    /**
     * Constructor method for Subscribe
     * @uses Subscribe::setAlarm()
     * @uses Subscribe::setNotification()
     * @param bool $alarm
     * @param bool $notification
     */
    public function __construct($alarm = null, $notification = null)
    {
        $this
            ->setAlarm($alarm)
            ->setNotification($notification);
    }
    /**
     * Get alarm value
     * @return bool|null
     */
    public function getAlarm()
    {
        return $this->alarm;
    }
    /**
     * Set alarm value
     * @param bool $alarm
     * @return \StructType\Subscribe
     */
    public function setAlarm($alarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($alarm) && !is_bool($alarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alarm)), __LINE__);
        }
        $this->alarm = $alarm;
        return $this;
    }
    /**
     * Get notification value
     * @return bool|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @param bool $notification
     * @return \StructType\Subscribe
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: boolean
        if (!is_null($notification) && !is_bool($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notification)), __LINE__);
        }
        $this->notification = $notification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subscribe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
