<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Status StructType
 * @subpackage Structs
 */
class Status extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - ref: tns:code
     * @var int
     */
    public $code;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info;
    /**
     * The problems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProblemList
     */
    public $problems;
    /**
     * Constructor method for Status
     * @uses Status::setCode()
     * @uses Status::setDescription()
     * @uses Status::setInfo()
     * @uses Status::setProblems()
     * @param int $code
     * @param string $description
     * @param string $info
     * @param \StructType\ProblemList $problems
     */
    public function __construct($code = null, $description = null, $info = null, \StructType\ProblemList $problems = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setInfo($info)
            ->setProblems($problems);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\Status
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Status
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\Status
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Get problems value
     * @return \StructType\ProblemList|null
     */
    public function getProblems()
    {
        return $this->problems;
    }
    /**
     * Set problems value
     * @param \StructType\ProblemList $problems
     * @return \StructType\Status
     */
    public function setProblems(\StructType\ProblemList $problems = null)
    {
        $this->problems = $problems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
