<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for startFreeBusySessionRequest StructType
 * @subpackage Structs
 */
class StartFreeBusySessionRequest extends AbstractStructBase
{
    /**
     * The users
     * @var \StructType\FreeBusyUserList
     */
    public $users;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for startFreeBusySessionRequest
     * @uses StartFreeBusySessionRequest::setUsers()
     * @uses StartFreeBusySessionRequest::setStartDate()
     * @uses StartFreeBusySessionRequest::setEndDate()
     * @param \StructType\FreeBusyUserList $users
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(\StructType\FreeBusyUserList $users = null, $startDate = null, $endDate = null)
    {
        $this
            ->setUsers($users)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get users value
     * @return \StructType\FreeBusyUserList|null
     */
    public function getUsers()
    {
        return $this->users;
    }
    /**
     * Set users value
     * @param \StructType\FreeBusyUserList $users
     * @return \StructType\StartFreeBusySessionRequest
     */
    public function setUsers(\StructType\FreeBusyUserList $users = null)
    {
        $this->users = $users;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\StartFreeBusySessionRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\StartFreeBusySessionRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartFreeBusySessionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
