<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sort StructType
 * @subpackage Structs
 */
class Sort extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The field
     * @var string
     */
    public $field;
    /**
     * Constructor method for Sort
     * @uses Sort::setType()
     * @uses Sort::setField()
     * @param string $type
     * @param string $field
     */
    public function __construct($type = null, $field = null)
    {
        $this
            ->setType($type)
            ->setField($field);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\SortType::valueIsValid()
     * @uses \EnumType\SortType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Sort
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\SortType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\Sort
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
