<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureSettings StructType
 * @subpackage Structs
 */
class SignatureSettings extends AbstractStructBase
{
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enabled;
    /**
     * The add
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $add;
    /**
     * Constructor method for SignatureSettings
     * @uses SignatureSettings::setEnabled()
     * @uses SignatureSettings::setAdd()
     * @param bool $enabled
     * @param string $add
     */
    public function __construct($enabled = null, $add = null)
    {
        $this
            ->setEnabled($enabled)
            ->setAdd($add);
    }
    /**
     * Get enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param bool $enabled
     * @return \StructType\SignatureSettings
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get add value
     * @return string|null
     */
    public function getAdd()
    {
        return $this->add;
    }
    /**
     * Set add value
     * @uses \EnumType\SignatureType::valueIsValid()
     * @uses \EnumType\SignatureType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $add
     * @return \StructType\SignatureSettings
     */
    public function setAdd($add = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SignatureType::valueIsValid($add)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $add, implode(', ', \EnumType\SignatureType::getValidValues())), __LINE__);
        }
        $this->add = $add;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignatureSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
