<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettingsList StructType
 * @subpackage Structs
 */
class SettingsList extends AbstractStructBase
{
    /**
     * The setting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom[]
     */
    public $setting;
    /**
     * Constructor method for SettingsList
     * @uses SettingsList::setSetting()
     * @param \StructType\Custom[] $setting
     */
    public function __construct(array $setting = array())
    {
        $this
            ->setSetting($setting);
    }
    /**
     * Get setting value
     * @return \StructType\Custom[]|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom[] $setting
     * @return \StructType\SettingsList
     */
    public function setSetting(array $setting = array())
    {
        foreach ($setting as $settingsListSettingItem) {
            // validation for constraint: itemType
            if (!$settingsListSettingItem instanceof \StructType\Custom) {
                throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($settingsListSettingItem) ? get_class($settingsListSettingItem) : gettype($settingsListSettingItem)), __LINE__);
            }
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Add item to setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom $item
     * @return \StructType\SettingsList
     */
    public function addToSetting(\StructType\Custom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom) {
            throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->setting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SettingsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
