<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettingsGroup StructType
 * @subpackage Structs
 */
class SettingsGroup extends AbstractStructBase
{
    /**
     * The setting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom[]
     */
    public $setting;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for SettingsGroup
     * @uses SettingsGroup::setSetting()
     * @uses SettingsGroup::setType()
     * @param \StructType\Custom[] $setting
     * @param string $type
     */
    public function __construct(array $setting = array(), $type = null)
    {
        $this
            ->setSetting($setting)
            ->setType($type);
    }
    /**
     * Get setting value
     * @return \StructType\Custom[]|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom[] $setting
     * @return \StructType\SettingsGroup
     */
    public function setSetting(array $setting = array())
    {
        foreach ($setting as $settingsGroupSettingItem) {
            // validation for constraint: itemType
            if (!$settingsGroupSettingItem instanceof \StructType\Custom) {
                throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($settingsGroupSettingItem) ? get_class($settingsGroupSettingItem) : gettype($settingsGroupSettingItem)), __LINE__);
            }
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Add item to setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom $item
     * @return \StructType\SettingsGroup
     */
    public function addToSetting(\StructType\Custom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom) {
            throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->setting[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\SettingsGroup
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SettingsGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
