<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Settings StructType
 * @subpackage Structs
 */
class Settings extends AbstractStructBase
{
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SettingsGroup[]
     */
    public $group;
    /**
     * The setting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Custom[]
     */
    public $setting;
    /**
     * Constructor method for Settings
     * @uses Settings::setGroup()
     * @uses Settings::setSetting()
     * @param \StructType\SettingsGroup[] $group
     * @param \StructType\Custom[] $setting
     */
    public function __construct(array $group = array(), array $setting = array())
    {
        $this
            ->setGroup($group)
            ->setSetting($setting);
    }
    /**
     * Get group value
     * @return \StructType\SettingsGroup[]|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @throws \InvalidArgumentException
     * @param \StructType\SettingsGroup[] $group
     * @return \StructType\Settings
     */
    public function setGroup(array $group = array())
    {
        foreach ($group as $settingsGroupItem) {
            // validation for constraint: itemType
            if (!$settingsGroupItem instanceof \StructType\SettingsGroup) {
                throw new \InvalidArgumentException(sprintf('The group property can only contain items of \StructType\SettingsGroup, "%s" given', is_object($settingsGroupItem) ? get_class($settingsGroupItem) : gettype($settingsGroupItem)), __LINE__);
            }
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Add item to group value
     * @throws \InvalidArgumentException
     * @param \StructType\SettingsGroup $item
     * @return \StructType\Settings
     */
    public function addToGroup(\StructType\SettingsGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SettingsGroup) {
            throw new \InvalidArgumentException(sprintf('The group property can only contain items of \StructType\SettingsGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->group[] = $item;
        return $this;
    }
    /**
     * Get setting value
     * @return \StructType\Custom[]|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom[] $setting
     * @return \StructType\Settings
     */
    public function setSetting(array $setting = array())
    {
        foreach ($setting as $settingsSettingItem) {
            // validation for constraint: itemType
            if (!$settingsSettingItem instanceof \StructType\Custom) {
                throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($settingsSettingItem) ? get_class($settingsSettingItem) : gettype($settingsSettingItem)), __LINE__);
            }
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Add item to setting value
     * @throws \InvalidArgumentException
     * @param \StructType\Custom $item
     * @return \StructType\Settings
     */
    public function addToSetting(\StructType\Custom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Custom) {
            throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \StructType\Custom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->setting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Settings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
