<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Server StructType
 * @subpackage Structs
 */
class Server extends AbstractStructBase
{
    /**
     * The host
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Host
     */
    public $host;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServerFlags
     */
    public $flags;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * Constructor method for Server
     * @uses Server::setHost()
     * @uses Server::setFlags()
     * @uses Server::setUserid()
     * @param \StructType\Host $host
     * @param \StructType\ServerFlags $flags
     * @param string $userid
     */
    public function __construct(\StructType\Host $host = null, \StructType\ServerFlags $flags = null, $userid = null)
    {
        $this
            ->setHost($host)
            ->setFlags($flags)
            ->setUserid($userid);
    }
    /**
     * Get host value
     * @return \StructType\Host|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * Set host value
     * @param \StructType\Host $host
     * @return \StructType\Server
     */
    public function setHost(\StructType\Host $host = null)
    {
        $this->host = $host;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\ServerFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\ServerFlags $flags
     * @return \StructType\Server
     */
    public function setFlags(\StructType\ServerFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\Server
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Server
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
