<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendOptions StructType
 * @subpackage Structs
 */
class SendOptions extends AbstractStructBase
{
    /**
     * The requestReply
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SendOptionsRequestReply
     */
    public $requestReply;
    /**
     * The mimeEncoding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mimeEncoding;
    /**
     * The statusTracking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusTracking
     */
    public $statusTracking;
    /**
     * The statusTrackingFlags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusTrackingFlags
     */
    public $statusTrackingFlags;
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotification
     */
    public $notification;
    /**
     * The updateFrequentContacts
     * Meta informations extracted from the WSDL
     * - default: 1
     * - minOccurs: 0
     * @var bool
     */
    public $updateFrequentContacts;
    /**
     * The workFlow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $workFlow;
    /**
     * The notifyRecipients
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $notifyRecipients;
    /**
     * The internetStatusTracking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InternetStatusTracking
     */
    public $internetStatusTracking;
    /**
     * Constructor method for SendOptions
     * @uses SendOptions::setRequestReply()
     * @uses SendOptions::setMimeEncoding()
     * @uses SendOptions::setStatusTracking()
     * @uses SendOptions::setStatusTrackingFlags()
     * @uses SendOptions::setNotification()
     * @uses SendOptions::setUpdateFrequentContacts()
     * @uses SendOptions::setWorkFlow()
     * @uses SendOptions::setNotifyRecipients()
     * @uses SendOptions::setInternetStatusTracking()
     * @param \StructType\SendOptionsRequestReply $requestReply
     * @param string $mimeEncoding
     * @param \StructType\StatusTracking $statusTracking
     * @param \StructType\StatusTrackingFlags $statusTrackingFlags
     * @param \StructType\ReturnNotification $notification
     * @param bool $updateFrequentContacts
     * @param bool $workFlow
     * @param bool $notifyRecipients
     * @param \StructType\InternetStatusTracking $internetStatusTracking
     */
    public function __construct(\StructType\SendOptionsRequestReply $requestReply = null, $mimeEncoding = null, \StructType\StatusTracking $statusTracking = null, \StructType\StatusTrackingFlags $statusTrackingFlags = null, \StructType\ReturnNotification $notification = null, $updateFrequentContacts = true, $workFlow = null, $notifyRecipients = null, \StructType\InternetStatusTracking $internetStatusTracking = null)
    {
        $this
            ->setRequestReply($requestReply)
            ->setMimeEncoding($mimeEncoding)
            ->setStatusTracking($statusTracking)
            ->setStatusTrackingFlags($statusTrackingFlags)
            ->setNotification($notification)
            ->setUpdateFrequentContacts($updateFrequentContacts)
            ->setWorkFlow($workFlow)
            ->setNotifyRecipients($notifyRecipients)
            ->setInternetStatusTracking($internetStatusTracking);
    }
    /**
     * Get requestReply value
     * @return \StructType\SendOptionsRequestReply|null
     */
    public function getRequestReply()
    {
        return $this->requestReply;
    }
    /**
     * Set requestReply value
     * @param \StructType\SendOptionsRequestReply $requestReply
     * @return \StructType\SendOptions
     */
    public function setRequestReply(\StructType\SendOptionsRequestReply $requestReply = null)
    {
        $this->requestReply = $requestReply;
        return $this;
    }
    /**
     * Get mimeEncoding value
     * @return string|null
     */
    public function getMimeEncoding()
    {
        return $this->mimeEncoding;
    }
    /**
     * Set mimeEncoding value
     * @param string $mimeEncoding
     * @return \StructType\SendOptions
     */
    public function setMimeEncoding($mimeEncoding = null)
    {
        // validation for constraint: string
        if (!is_null($mimeEncoding) && !is_string($mimeEncoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeEncoding)), __LINE__);
        }
        $this->mimeEncoding = $mimeEncoding;
        return $this;
    }
    /**
     * Get statusTracking value
     * @return \StructType\StatusTracking|null
     */
    public function getStatusTracking()
    {
        return $this->statusTracking;
    }
    /**
     * Set statusTracking value
     * @param \StructType\StatusTracking $statusTracking
     * @return \StructType\SendOptions
     */
    public function setStatusTracking(\StructType\StatusTracking $statusTracking = null)
    {
        $this->statusTracking = $statusTracking;
        return $this;
    }
    /**
     * Get statusTrackingFlags value
     * @return \StructType\StatusTrackingFlags|null
     */
    public function getStatusTrackingFlags()
    {
        return $this->statusTrackingFlags;
    }
    /**
     * Set statusTrackingFlags value
     * @param \StructType\StatusTrackingFlags $statusTrackingFlags
     * @return \StructType\SendOptions
     */
    public function setStatusTrackingFlags(\StructType\StatusTrackingFlags $statusTrackingFlags = null)
    {
        $this->statusTrackingFlags = $statusTrackingFlags;
        return $this;
    }
    /**
     * Get notification value
     * @return \StructType\ReturnNotification|null
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @param \StructType\ReturnNotification $notification
     * @return \StructType\SendOptions
     */
    public function setNotification(\StructType\ReturnNotification $notification = null)
    {
        $this->notification = $notification;
        return $this;
    }
    /**
     * Get updateFrequentContacts value
     * @return bool|null
     */
    public function getUpdateFrequentContacts()
    {
        return $this->updateFrequentContacts;
    }
    /**
     * Set updateFrequentContacts value
     * @param bool $updateFrequentContacts
     * @return \StructType\SendOptions
     */
    public function setUpdateFrequentContacts($updateFrequentContacts = true)
    {
        // validation for constraint: boolean
        if (!is_null($updateFrequentContacts) && !is_bool($updateFrequentContacts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($updateFrequentContacts)), __LINE__);
        }
        $this->updateFrequentContacts = $updateFrequentContacts;
        return $this;
    }
    /**
     * Get workFlow value
     * @return bool|null
     */
    public function getWorkFlow()
    {
        return $this->workFlow;
    }
    /**
     * Set workFlow value
     * @param bool $workFlow
     * @return \StructType\SendOptions
     */
    public function setWorkFlow($workFlow = null)
    {
        // validation for constraint: boolean
        if (!is_null($workFlow) && !is_bool($workFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($workFlow)), __LINE__);
        }
        $this->workFlow = $workFlow;
        return $this;
    }
    /**
     * Get notifyRecipients value
     * @return bool|null
     */
    public function getNotifyRecipients()
    {
        return $this->notifyRecipients;
    }
    /**
     * Set notifyRecipients value
     * @param bool $notifyRecipients
     * @return \StructType\SendOptions
     */
    public function setNotifyRecipients($notifyRecipients = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyRecipients) && !is_bool($notifyRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyRecipients)), __LINE__);
        }
        $this->notifyRecipients = $notifyRecipients;
        return $this;
    }
    /**
     * Get internetStatusTracking value
     * @return \StructType\InternetStatusTracking|null
     */
    public function getInternetStatusTracking()
    {
        return $this->internetStatusTracking;
    }
    /**
     * Set internetStatusTracking value
     * @param \StructType\InternetStatusTracking $internetStatusTracking
     * @return \StructType\SendOptions
     */
    public function setInternetStatusTracking(\StructType\InternetStatusTracking $internetStatusTracking = null)
    {
        $this->internetStatusTracking = $internetStatusTracking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
