<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleActionList StructType
 * @subpackage Structs
 */
class RuleActionList extends AbstractStructBase
{
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RuleAction[]
     */
    public $action;
    /**
     * Constructor method for RuleActionList
     * @uses RuleActionList::setAction()
     * @param \StructType\RuleAction[] $action
     */
    public function __construct(array $action = array())
    {
        $this
            ->setAction($action);
    }
    /**
     * Get action value
     * @return \StructType\RuleAction[]|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleAction[] $action
     * @return \StructType\RuleActionList
     */
    public function setAction(array $action = array())
    {
        foreach ($action as $ruleActionListActionItem) {
            // validation for constraint: itemType
            if (!$ruleActionListActionItem instanceof \StructType\RuleAction) {
                throw new \InvalidArgumentException(sprintf('The action property can only contain items of \StructType\RuleAction, "%s" given', is_object($ruleActionListActionItem) ? get_class($ruleActionListActionItem) : gettype($ruleActionListActionItem)), __LINE__);
            }
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Add item to action value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleAction $item
     * @return \StructType\RuleActionList
     */
    public function addToAction(\StructType\RuleAction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RuleAction) {
            throw new \InvalidArgumentException(sprintf('The action property can only contain items of \StructType\RuleAction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->action[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuleActionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
