<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleAction StructType
 * @subpackage Structs
 */
class RuleAction extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mail
     */
    public $item;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The acceptLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:acceptLevel
     * @var string
     */
    public $acceptLevel;
    /**
     * The categories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CategoryRefList
     */
    public $categories;
    /**
     * Constructor method for RuleAction
     * @uses RuleAction::setContainer()
     * @uses RuleAction::setType()
     * @uses RuleAction::setItem()
     * @uses RuleAction::setMessage()
     * @uses RuleAction::setAcceptLevel()
     * @uses RuleAction::setCategories()
     * @param string $container
     * @param string $type
     * @param \StructType\Mail $item
     * @param string $message
     * @param string $acceptLevel
     * @param \StructType\CategoryRefList $categories
     */
    public function __construct($container = null, $type = null, \StructType\Mail $item = null, $message = null, $acceptLevel = null, \StructType\CategoryRefList $categories = null)
    {
        $this
            ->setContainer($container)
            ->setType($type)
            ->setItem($item)
            ->setMessage($message)
            ->setAcceptLevel($acceptLevel)
            ->setCategories($categories);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\RuleAction
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RuleActionType::valueIsValid()
     * @uses \EnumType\RuleActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\RuleAction
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RuleActionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RuleActionType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\Mail|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\Mail $item
     * @return \StructType\RuleAction
     */
    public function setItem(\StructType\Mail $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\RuleAction
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get acceptLevel value
     * @return string|null
     */
    public function getAcceptLevel()
    {
        return $this->acceptLevel;
    }
    /**
     * Set acceptLevel value
     * @uses \EnumType\AcceptLevel::valueIsValid()
     * @uses \EnumType\AcceptLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptLevel
     * @return \StructType\RuleAction
     */
    public function setAcceptLevel($acceptLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AcceptLevel::valueIsValid($acceptLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptLevel, implode(', ', \EnumType\AcceptLevel::getValidValues())), __LINE__);
        }
        $this->acceptLevel = $acceptLevel;
        return $this;
    }
    /**
     * Get categories value
     * @return \StructType\CategoryRefList|null
     */
    public function getCategories()
    {
        return $this->categories;
    }
    /**
     * Set categories value
     * @param \StructType\CategoryRefList $categories
     * @return \StructType\RuleAction
     */
    public function setCategories(\StructType\CategoryRefList $categories = null)
    {
        $this->categories = $categories;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuleAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
