<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rule StructType
 * @subpackage Structs
 */
class Rule extends ContainerItem
{
    /**
     * The execution
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $execution;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sequence
     * @var int
     */
    public $sequence;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enabled;
    /**
     * The types
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $types;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The conflict
     * Meta informations extracted from the WSDL
     * - default: Ignore
     * - minOccurs: 0
     * @var string
     */
    public $conflict;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $filter;
    /**
     * The actions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RuleActionList
     */
    public $actions;
    /**
     * Constructor method for Rule
     * @uses Rule::setExecution()
     * @uses Rule::setSequence()
     * @uses Rule::setEnabled()
     * @uses Rule::setTypes()
     * @uses Rule::setSource()
     * @uses Rule::setConflict()
     * @uses Rule::setFilter()
     * @uses Rule::setActions()
     * @param string $execution
     * @param int $sequence
     * @param bool $enabled
     * @param string $types
     * @param string $source
     * @param string $conflict
     * @param \StructType\Filter $filter
     * @param \StructType\RuleActionList $actions
     */
    public function __construct($execution = null, $sequence = null, $enabled = null, $types = null, $source = null, $conflict = 'Ignore', \StructType\Filter $filter = null, \StructType\RuleActionList $actions = null)
    {
        $this
            ->setExecution($execution)
            ->setSequence($sequence)
            ->setEnabled($enabled)
            ->setTypes($types)
            ->setSource($source)
            ->setConflict($conflict)
            ->setFilter($filter)
            ->setActions($actions);
    }
    /**
     * Get execution value
     * @return string|null
     */
    public function getExecution()
    {
        return $this->execution;
    }
    /**
     * Set execution value
     * @uses \EnumType\Execution::valueIsValid()
     * @uses \EnumType\Execution::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $execution
     * @return \StructType\Rule
     */
    public function setExecution($execution = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Execution::valueIsValid($execution)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $execution, implode(', ', \EnumType\Execution::getValidValues())), __LINE__);
        }
        $this->execution = $execution;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\Rule
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param bool $enabled
     * @return \StructType\Rule
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get types value
     * @return string|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @param string $types
     * @return \StructType\Rule
     */
    public function setTypes($types = null)
    {
        // validation for constraint: string
        if (!is_null($types) && !is_string($types)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($types)), __LINE__);
        }
        $this->types = $types;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Rule
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get conflict value
     * @return string|null
     */
    public function getConflict()
    {
        return $this->conflict;
    }
    /**
     * Set conflict value
     * @uses \EnumType\AppointmentConflict::valueIsValid()
     * @uses \EnumType\AppointmentConflict::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $conflict
     * @return \StructType\Rule
     */
    public function setConflict($conflict = 'Ignore')
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppointmentConflict::valueIsValid($conflict)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $conflict, implode(', ', \EnumType\AppointmentConflict::getValidValues())), __LINE__);
        }
        $this->conflict = $conflict;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\Filter $filter
     * @return \StructType\Rule
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get actions value
     * @return \StructType\RuleActionList|null
     */
    public function getActions()
    {
        return $this->actions;
    }
    /**
     * Set actions value
     * @param \StructType\RuleActionList $actions
     * @return \StructType\Rule
     */
    public function setActions(\StructType\RuleActionList $actions = null)
    {
        $this->actions = $actions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
