<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnNotificationOptions StructType
 * @subpackage Structs
 */
class ReturnNotificationOptions extends AbstractStructBase
{
    /**
     * The mail
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $mail;
    /**
     * The notify
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $notify;
    /**
     * Constructor method for ReturnNotificationOptions
     * @uses ReturnNotificationOptions::setMail()
     * @uses ReturnNotificationOptions::setNotify()
     * @param bool $mail
     * @param bool $notify
     */
    public function __construct($mail = false, $notify = false)
    {
        $this
            ->setMail($mail)
            ->setNotify($notify);
    }
    /**
     * Get mail value
     * @return bool|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param bool $mail
     * @return \StructType\ReturnNotificationOptions
     */
    public function setMail($mail = false)
    {
        // validation for constraint: boolean
        if (!is_null($mail) && !is_bool($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get notify value
     * @return bool|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param bool $notify
     * @return \StructType\ReturnNotificationOptions
     */
    public function setNotify($notify = false)
    {
        // validation for constraint: boolean
        if (!is_null($notify) && !is_bool($notify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notify)), __LINE__);
        }
        $this->notify = $notify;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReturnNotificationOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
