<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for retractRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: If a recipient has opened or accepted a Calendar item, a notice will be placed in the recipient's in-box when the item is retracted. The notice can be affected by the following options: "comment": The comment will be included in the
 * notice. "retractCausedByResend": When TRUE, the notice will be suppressed in lieu of the 'new' calendar item that will be delivered to the recipient. "retractingAllInstances": When TRUE, a single notice will be placed in the recipient's in-box
 * (instead of a notice for each auto-date instance). If no retractType is specified, the default is recipientMailboxes.
 * @subpackage Structs
 */
class RetractRequest extends AbstractStructBase
{
    /**
     * The items
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The retractingAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $retractingAllInstances;
    /**
     * The retractCausedByResend
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $retractCausedByResend;
    /**
     * The retractType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retractType;
    /**
     * Constructor method for retractRequest
     * @uses RetractRequest::setItems()
     * @uses RetractRequest::setComment()
     * @uses RetractRequest::setRetractingAllInstances()
     * @uses RetractRequest::setRetractCausedByResend()
     * @uses RetractRequest::setRetractType()
     * @param \StructType\ItemRefList $items
     * @param string $comment
     * @param int $retractingAllInstances
     * @param bool $retractCausedByResend
     * @param string $retractType
     */
    public function __construct(\StructType\ItemRefList $items = null, $comment = null, $retractingAllInstances = null, $retractCausedByResend = null, $retractType = null)
    {
        $this
            ->setItems($items)
            ->setComment($comment)
            ->setRetractingAllInstances($retractingAllInstances)
            ->setRetractCausedByResend($retractCausedByResend)
            ->setRetractType($retractType);
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\RetractRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\RetractRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get retractingAllInstances value
     * @return int|null
     */
    public function getRetractingAllInstances()
    {
        return $this->retractingAllInstances;
    }
    /**
     * Set retractingAllInstances value
     * @param int $retractingAllInstances
     * @return \StructType\RetractRequest
     */
    public function setRetractingAllInstances($retractingAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($retractingAllInstances) && !is_numeric($retractingAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($retractingAllInstances)), __LINE__);
        }
        $this->retractingAllInstances = $retractingAllInstances;
        return $this;
    }
    /**
     * Get retractCausedByResend value
     * @return bool|null
     */
    public function getRetractCausedByResend()
    {
        return $this->retractCausedByResend;
    }
    /**
     * Set retractCausedByResend value
     * @param bool $retractCausedByResend
     * @return \StructType\RetractRequest
     */
    public function setRetractCausedByResend($retractCausedByResend = null)
    {
        // validation for constraint: boolean
        if (!is_null($retractCausedByResend) && !is_bool($retractCausedByResend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retractCausedByResend)), __LINE__);
        }
        $this->retractCausedByResend = $retractCausedByResend;
        return $this;
    }
    /**
     * Get retractType value
     * @return string|null
     */
    public function getRetractType()
    {
        return $this->retractType;
    }
    /**
     * Set retractType value
     * @uses \EnumType\RetractType::valueIsValid()
     * @uses \EnumType\RetractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retractType
     * @return \StructType\RetractRequest
     */
    public function setRetractType($retractType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetractType::valueIsValid($retractType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retractType, implode(', ', \EnumType\RetractType::getValidValues())), __LINE__);
        }
        $this->retractType = $retractType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetractRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
