<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeSignatureRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: The signature will be purged when remove request completed. The missing id node when it is not delete all signatures indicates the removing of plain text signature which resides in user's settings record.
 * @subpackage Structs
 */
class RemoveSignatureRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The all
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $all;
    /**
     * The global
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $global;
    /**
     * Constructor method for removeSignatureRequest
     * @uses RemoveSignatureRequest::setId()
     * @uses RemoveSignatureRequest::setAll()
     * @uses RemoveSignatureRequest::setGlobal()
     * @param string $id
     * @param bool $all
     * @param bool $global
     */
    public function __construct($id = null, $all = null, $global = false)
    {
        $this
            ->setId($id)
            ->setAll($all)
            ->setGlobal($global);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RemoveSignatureRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get all value
     * @return bool|null
     */
    public function getAll()
    {
        return $this->all;
    }
    /**
     * Set all value
     * @param bool $all
     * @return \StructType\RemoveSignatureRequest
     */
    public function setAll($all = null)
    {
        // validation for constraint: boolean
        if (!is_null($all) && !is_bool($all)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($all)), __LINE__);
        }
        $this->all = $all;
        return $this;
    }
    /**
     * Get global value
     * @return bool|null
     */
    public function getGlobal()
    {
        return $this->global;
    }
    /**
     * Set global value
     * @param bool $global
     * @return \StructType\RemoveSignatureRequest
     */
    public function setGlobal($global = false)
    {
        // validation for constraint: boolean
        if (!is_null($global) && !is_bool($global)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($global)), __LINE__);
        }
        $this->global = $global;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveSignatureRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
