<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeItemRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: If the container is not specified then the item is removed from all of the containers that it is linked to and is stored in the "Trash". If the container is specified then the item is only removed from that specific container and
 * it's link is stored in the "Trash".
 * @subpackage Structs
 */
class RemoveItemRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * Constructor method for removeItemRequest
     * @uses RemoveItemRequest::setContainer()
     * @uses RemoveItemRequest::setId()
     * @param string $container
     * @param string $id
     */
    public function __construct($container = null, $id = null)
    {
        $this
            ->setContainer($container)
            ->setId($id);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\RemoveItemRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\RemoveItemRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
