<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceInfo StructType
 * @subpackage Structs
 */
class ReferenceInfo extends AbstractStructBase
{
    /**
     * The lastReferenceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastReferenceDate;
    /**
     * The referenceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $referenceCount;
    /**
     * Constructor method for ReferenceInfo
     * @uses ReferenceInfo::setLastReferenceDate()
     * @uses ReferenceInfo::setReferenceCount()
     * @param string $lastReferenceDate
     * @param int $referenceCount
     */
    public function __construct($lastReferenceDate = null, $referenceCount = null)
    {
        $this
            ->setLastReferenceDate($lastReferenceDate)
            ->setReferenceCount($referenceCount);
    }
    /**
     * Get lastReferenceDate value
     * @return string|null
     */
    public function getLastReferenceDate()
    {
        return $this->lastReferenceDate;
    }
    /**
     * Set lastReferenceDate value
     * @param string $lastReferenceDate
     * @return \StructType\ReferenceInfo
     */
    public function setLastReferenceDate($lastReferenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferenceDate) && !is_string($lastReferenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastReferenceDate)), __LINE__);
        }
        $this->lastReferenceDate = $lastReferenceDate;
        return $this;
    }
    /**
     * Get referenceCount value
     * @return int|null
     */
    public function getReferenceCount()
    {
        return $this->referenceCount;
    }
    /**
     * Set referenceCount value
     * @param int $referenceCount
     * @return \StructType\ReferenceInfo
     */
    public function setReferenceCount($referenceCount = null)
    {
        // validation for constraint: int
        if (!is_null($referenceCount) && !is_numeric($referenceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referenceCount)), __LINE__);
        }
        $this->referenceCount = $referenceCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
