<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurrenceDateType StructType
 * @subpackage Structs
 */
class RecurrenceDateType extends AbstractStructBase
{
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $date;
    /**
     * Constructor method for RecurrenceDateType
     * @uses RecurrenceDateType::setDate()
     * @param string[] $date
     */
    public function __construct(array $date = array())
    {
        $this
            ->setDate($date);
    }
    /**
     * Get date value
     * @return string[]|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @throws \InvalidArgumentException
     * @param string[] $date
     * @return \StructType\RecurrenceDateType
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $recurrenceDateTypeDateItem) {
            // validation for constraint: itemType
            if (!is_string($recurrenceDateTypeDateItem)) {
                throw new \InvalidArgumentException(sprintf('The date property can only contain items of date, "%s" given', is_object($recurrenceDateTypeDateItem) ? get_class($recurrenceDateTypeDateItem) : gettype($recurrenceDateTypeDateItem)), __LINE__);
            }
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Add item to date value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RecurrenceDateType
     */
    public function addToDate($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The date property can only contain items of date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->date[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurrenceDateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
