<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipientStatus StructType
 * @subpackage Structs
 */
class RecipientStatus extends AbstractStructBase
{
    /**
     * The delivered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $delivered;
    /**
     * The undeliverable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommentStatus
     */
    public $undeliverable;
    /**
     * The transferred
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferred;
    /**
     * The transferDelayed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferDelayed;
    /**
     * The transferFailed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transferFailed;
    /**
     * The downloaded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $downloaded;
    /**
     * The downloadedByThirdParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $downloadedByThirdParty;
    /**
     * The retractRequested
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retractRequested;
    /**
     * The retracted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retracted;
    /**
     * The opened
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opened;
    /**
     * The deleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deleted;
    /**
     * The undeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $undeleted;
    /**
     * The purged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purged;
    /**
     * The accepted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommentStatus
     */
    public $accepted;
    /**
     * The declined
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommentStatus
     */
    public $declined;
    /**
     * The replied
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replied;
    /**
     * The forwarded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $forwarded;
    /**
     * The shared
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shared;
    /**
     * The started
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $started;
    /**
     * The completed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $completed;
    /**
     * The incomplete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $incomplete;
    /**
     * The delegated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DelegatedStatus
     */
    public $delegated;
    /**
     * The delegateeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DelegateeStatus[]
     */
    public $delegateeStatus;
    /**
     * Constructor method for RecipientStatus
     * @uses RecipientStatus::setDelivered()
     * @uses RecipientStatus::setUndeliverable()
     * @uses RecipientStatus::setTransferred()
     * @uses RecipientStatus::setTransferDelayed()
     * @uses RecipientStatus::setTransferFailed()
     * @uses RecipientStatus::setDownloaded()
     * @uses RecipientStatus::setDownloadedByThirdParty()
     * @uses RecipientStatus::setRetractRequested()
     * @uses RecipientStatus::setRetracted()
     * @uses RecipientStatus::setOpened()
     * @uses RecipientStatus::setDeleted()
     * @uses RecipientStatus::setUndeleted()
     * @uses RecipientStatus::setPurged()
     * @uses RecipientStatus::setAccepted()
     * @uses RecipientStatus::setDeclined()
     * @uses RecipientStatus::setReplied()
     * @uses RecipientStatus::setForwarded()
     * @uses RecipientStatus::setShared()
     * @uses RecipientStatus::setStarted()
     * @uses RecipientStatus::setCompleted()
     * @uses RecipientStatus::setIncomplete()
     * @uses RecipientStatus::setDelegated()
     * @uses RecipientStatus::setDelegateeStatus()
     * @param string $delivered
     * @param \StructType\CommentStatus $undeliverable
     * @param string $transferred
     * @param string $transferDelayed
     * @param string $transferFailed
     * @param string $downloaded
     * @param string $downloadedByThirdParty
     * @param string $retractRequested
     * @param string $retracted
     * @param string $opened
     * @param string $deleted
     * @param string $undeleted
     * @param string $purged
     * @param \StructType\CommentStatus $accepted
     * @param \StructType\CommentStatus $declined
     * @param string $replied
     * @param string $forwarded
     * @param string $shared
     * @param string $started
     * @param string $completed
     * @param string $incomplete
     * @param \StructType\DelegatedStatus $delegated
     * @param \StructType\DelegateeStatus[] $delegateeStatus
     */
    public function __construct($delivered = null, \StructType\CommentStatus $undeliverable = null, $transferred = null, $transferDelayed = null, $transferFailed = null, $downloaded = null, $downloadedByThirdParty = null, $retractRequested = null, $retracted = null, $opened = null, $deleted = null, $undeleted = null, $purged = null, \StructType\CommentStatus $accepted = null, \StructType\CommentStatus $declined = null, $replied = null, $forwarded = null, $shared = null, $started = null, $completed = null, $incomplete = null, \StructType\DelegatedStatus $delegated = null, array $delegateeStatus = array())
    {
        $this
            ->setDelivered($delivered)
            ->setUndeliverable($undeliverable)
            ->setTransferred($transferred)
            ->setTransferDelayed($transferDelayed)
            ->setTransferFailed($transferFailed)
            ->setDownloaded($downloaded)
            ->setDownloadedByThirdParty($downloadedByThirdParty)
            ->setRetractRequested($retractRequested)
            ->setRetracted($retracted)
            ->setOpened($opened)
            ->setDeleted($deleted)
            ->setUndeleted($undeleted)
            ->setPurged($purged)
            ->setAccepted($accepted)
            ->setDeclined($declined)
            ->setReplied($replied)
            ->setForwarded($forwarded)
            ->setShared($shared)
            ->setStarted($started)
            ->setCompleted($completed)
            ->setIncomplete($incomplete)
            ->setDelegated($delegated)
            ->setDelegateeStatus($delegateeStatus);
    }
    /**
     * Get delivered value
     * @return string|null
     */
    public function getDelivered()
    {
        return $this->delivered;
    }
    /**
     * Set delivered value
     * @param string $delivered
     * @return \StructType\RecipientStatus
     */
    public function setDelivered($delivered = null)
    {
        // validation for constraint: string
        if (!is_null($delivered) && !is_string($delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delivered)), __LINE__);
        }
        $this->delivered = $delivered;
        return $this;
    }
    /**
     * Get undeliverable value
     * @return \StructType\CommentStatus|null
     */
    public function getUndeliverable()
    {
        return $this->undeliverable;
    }
    /**
     * Set undeliverable value
     * @param \StructType\CommentStatus $undeliverable
     * @return \StructType\RecipientStatus
     */
    public function setUndeliverable(\StructType\CommentStatus $undeliverable = null)
    {
        $this->undeliverable = $undeliverable;
        return $this;
    }
    /**
     * Get transferred value
     * @return string|null
     */
    public function getTransferred()
    {
        return $this->transferred;
    }
    /**
     * Set transferred value
     * @param string $transferred
     * @return \StructType\RecipientStatus
     */
    public function setTransferred($transferred = null)
    {
        // validation for constraint: string
        if (!is_null($transferred) && !is_string($transferred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferred)), __LINE__);
        }
        $this->transferred = $transferred;
        return $this;
    }
    /**
     * Get transferDelayed value
     * @return string|null
     */
    public function getTransferDelayed()
    {
        return $this->transferDelayed;
    }
    /**
     * Set transferDelayed value
     * @param string $transferDelayed
     * @return \StructType\RecipientStatus
     */
    public function setTransferDelayed($transferDelayed = null)
    {
        // validation for constraint: string
        if (!is_null($transferDelayed) && !is_string($transferDelayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferDelayed)), __LINE__);
        }
        $this->transferDelayed = $transferDelayed;
        return $this;
    }
    /**
     * Get transferFailed value
     * @return string|null
     */
    public function getTransferFailed()
    {
        return $this->transferFailed;
    }
    /**
     * Set transferFailed value
     * @param string $transferFailed
     * @return \StructType\RecipientStatus
     */
    public function setTransferFailed($transferFailed = null)
    {
        // validation for constraint: string
        if (!is_null($transferFailed) && !is_string($transferFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transferFailed)), __LINE__);
        }
        $this->transferFailed = $transferFailed;
        return $this;
    }
    /**
     * Get downloaded value
     * @return string|null
     */
    public function getDownloaded()
    {
        return $this->downloaded;
    }
    /**
     * Set downloaded value
     * @param string $downloaded
     * @return \StructType\RecipientStatus
     */
    public function setDownloaded($downloaded = null)
    {
        // validation for constraint: string
        if (!is_null($downloaded) && !is_string($downloaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($downloaded)), __LINE__);
        }
        $this->downloaded = $downloaded;
        return $this;
    }
    /**
     * Get downloadedByThirdParty value
     * @return string|null
     */
    public function getDownloadedByThirdParty()
    {
        return $this->downloadedByThirdParty;
    }
    /**
     * Set downloadedByThirdParty value
     * @param string $downloadedByThirdParty
     * @return \StructType\RecipientStatus
     */
    public function setDownloadedByThirdParty($downloadedByThirdParty = null)
    {
        // validation for constraint: string
        if (!is_null($downloadedByThirdParty) && !is_string($downloadedByThirdParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($downloadedByThirdParty)), __LINE__);
        }
        $this->downloadedByThirdParty = $downloadedByThirdParty;
        return $this;
    }
    /**
     * Get retractRequested value
     * @return string|null
     */
    public function getRetractRequested()
    {
        return $this->retractRequested;
    }
    /**
     * Set retractRequested value
     * @param string $retractRequested
     * @return \StructType\RecipientStatus
     */
    public function setRetractRequested($retractRequested = null)
    {
        // validation for constraint: string
        if (!is_null($retractRequested) && !is_string($retractRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retractRequested)), __LINE__);
        }
        $this->retractRequested = $retractRequested;
        return $this;
    }
    /**
     * Get retracted value
     * @return string|null
     */
    public function getRetracted()
    {
        return $this->retracted;
    }
    /**
     * Set retracted value
     * @param string $retracted
     * @return \StructType\RecipientStatus
     */
    public function setRetracted($retracted = null)
    {
        // validation for constraint: string
        if (!is_null($retracted) && !is_string($retracted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retracted)), __LINE__);
        }
        $this->retracted = $retracted;
        return $this;
    }
    /**
     * Get opened value
     * @return string|null
     */
    public function getOpened()
    {
        return $this->opened;
    }
    /**
     * Set opened value
     * @param string $opened
     * @return \StructType\RecipientStatus
     */
    public function setOpened($opened = null)
    {
        // validation for constraint: string
        if (!is_null($opened) && !is_string($opened)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opened)), __LINE__);
        }
        $this->opened = $opened;
        return $this;
    }
    /**
     * Get deleted value
     * @return string|null
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Set deleted value
     * @param string $deleted
     * @return \StructType\RecipientStatus
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: string
        if (!is_null($deleted) && !is_string($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deleted)), __LINE__);
        }
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Get undeleted value
     * @return string|null
     */
    public function getUndeleted()
    {
        return $this->undeleted;
    }
    /**
     * Set undeleted value
     * @param string $undeleted
     * @return \StructType\RecipientStatus
     */
    public function setUndeleted($undeleted = null)
    {
        // validation for constraint: string
        if (!is_null($undeleted) && !is_string($undeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($undeleted)), __LINE__);
        }
        $this->undeleted = $undeleted;
        return $this;
    }
    /**
     * Get purged value
     * @return string|null
     */
    public function getPurged()
    {
        return $this->purged;
    }
    /**
     * Set purged value
     * @param string $purged
     * @return \StructType\RecipientStatus
     */
    public function setPurged($purged = null)
    {
        // validation for constraint: string
        if (!is_null($purged) && !is_string($purged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purged)), __LINE__);
        }
        $this->purged = $purged;
        return $this;
    }
    /**
     * Get accepted value
     * @return \StructType\CommentStatus|null
     */
    public function getAccepted()
    {
        return $this->accepted;
    }
    /**
     * Set accepted value
     * @param \StructType\CommentStatus $accepted
     * @return \StructType\RecipientStatus
     */
    public function setAccepted(\StructType\CommentStatus $accepted = null)
    {
        $this->accepted = $accepted;
        return $this;
    }
    /**
     * Get declined value
     * @return \StructType\CommentStatus|null
     */
    public function getDeclined()
    {
        return $this->declined;
    }
    /**
     * Set declined value
     * @param \StructType\CommentStatus $declined
     * @return \StructType\RecipientStatus
     */
    public function setDeclined(\StructType\CommentStatus $declined = null)
    {
        $this->declined = $declined;
        return $this;
    }
    /**
     * Get replied value
     * @return string|null
     */
    public function getReplied()
    {
        return $this->replied;
    }
    /**
     * Set replied value
     * @param string $replied
     * @return \StructType\RecipientStatus
     */
    public function setReplied($replied = null)
    {
        // validation for constraint: string
        if (!is_null($replied) && !is_string($replied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replied)), __LINE__);
        }
        $this->replied = $replied;
        return $this;
    }
    /**
     * Get forwarded value
     * @return string|null
     */
    public function getForwarded()
    {
        return $this->forwarded;
    }
    /**
     * Set forwarded value
     * @param string $forwarded
     * @return \StructType\RecipientStatus
     */
    public function setForwarded($forwarded = null)
    {
        // validation for constraint: string
        if (!is_null($forwarded) && !is_string($forwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwarded)), __LINE__);
        }
        $this->forwarded = $forwarded;
        return $this;
    }
    /**
     * Get shared value
     * @return string|null
     */
    public function getShared()
    {
        return $this->shared;
    }
    /**
     * Set shared value
     * @param string $shared
     * @return \StructType\RecipientStatus
     */
    public function setShared($shared = null)
    {
        // validation for constraint: string
        if (!is_null($shared) && !is_string($shared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shared)), __LINE__);
        }
        $this->shared = $shared;
        return $this;
    }
    /**
     * Get started value
     * @return string|null
     */
    public function getStarted()
    {
        return $this->started;
    }
    /**
     * Set started value
     * @param string $started
     * @return \StructType\RecipientStatus
     */
    public function setStarted($started = null)
    {
        // validation for constraint: string
        if (!is_null($started) && !is_string($started)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($started)), __LINE__);
        }
        $this->started = $started;
        return $this;
    }
    /**
     * Get completed value
     * @return string|null
     */
    public function getCompleted()
    {
        return $this->completed;
    }
    /**
     * Set completed value
     * @param string $completed
     * @return \StructType\RecipientStatus
     */
    public function setCompleted($completed = null)
    {
        // validation for constraint: string
        if (!is_null($completed) && !is_string($completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completed)), __LINE__);
        }
        $this->completed = $completed;
        return $this;
    }
    /**
     * Get incomplete value
     * @return string|null
     */
    public function getIncomplete()
    {
        return $this->incomplete;
    }
    /**
     * Set incomplete value
     * @param string $incomplete
     * @return \StructType\RecipientStatus
     */
    public function setIncomplete($incomplete = null)
    {
        // validation for constraint: string
        if (!is_null($incomplete) && !is_string($incomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomplete)), __LINE__);
        }
        $this->incomplete = $incomplete;
        return $this;
    }
    /**
     * Get delegated value
     * @return \StructType\DelegatedStatus|null
     */
    public function getDelegated()
    {
        return $this->delegated;
    }
    /**
     * Set delegated value
     * @param \StructType\DelegatedStatus $delegated
     * @return \StructType\RecipientStatus
     */
    public function setDelegated(\StructType\DelegatedStatus $delegated = null)
    {
        $this->delegated = $delegated;
        return $this;
    }
    /**
     * Get delegateeStatus value
     * @return \StructType\DelegateeStatus[]|null
     */
    public function getDelegateeStatus()
    {
        return $this->delegateeStatus;
    }
    /**
     * Set delegateeStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\DelegateeStatus[] $delegateeStatus
     * @return \StructType\RecipientStatus
     */
    public function setDelegateeStatus(array $delegateeStatus = array())
    {
        foreach ($delegateeStatus as $recipientStatusDelegateeStatusItem) {
            // validation for constraint: itemType
            if (!$recipientStatusDelegateeStatusItem instanceof \StructType\DelegateeStatus) {
                throw new \InvalidArgumentException(sprintf('The delegateeStatus property can only contain items of \StructType\DelegateeStatus, "%s" given', is_object($recipientStatusDelegateeStatusItem) ? get_class($recipientStatusDelegateeStatusItem) : gettype($recipientStatusDelegateeStatusItem)), __LINE__);
            }
        }
        $this->delegateeStatus = $delegateeStatus;
        return $this;
    }
    /**
     * Add item to delegateeStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\DelegateeStatus $item
     * @return \StructType\RecipientStatus
     */
    public function addToDelegateeStatus(\StructType\DelegateeStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DelegateeStatus) {
            throw new \InvalidArgumentException(sprintf('The delegateeStatus property can only contain items of \StructType\DelegateeStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->delegateeStatus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecipientStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
