<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipientList StructType
 * @subpackage Structs
 */
class RecipientList extends AbstractStructBase
{
    /**
     * The recipient
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recipient[]
     */
    public $recipient;
    /**
     * Constructor method for RecipientList
     * @uses RecipientList::setRecipient()
     * @param \StructType\Recipient[] $recipient
     */
    public function __construct(array $recipient = array())
    {
        $this
            ->setRecipient($recipient);
    }
    /**
     * Get recipient value
     * @return \StructType\Recipient[]|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @throws \InvalidArgumentException
     * @param \StructType\Recipient[] $recipient
     * @return \StructType\RecipientList
     */
    public function setRecipient(array $recipient = array())
    {
        foreach ($recipient as $recipientListRecipientItem) {
            // validation for constraint: itemType
            if (!$recipientListRecipientItem instanceof \StructType\Recipient) {
                throw new \InvalidArgumentException(sprintf('The recipient property can only contain items of \StructType\Recipient, "%s" given', is_object($recipientListRecipientItem) ? get_class($recipientListRecipientItem) : gettype($recipientListRecipientItem)), __LINE__);
            }
        }
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Add item to recipient value
     * @throws \InvalidArgumentException
     * @param \StructType\Recipient $item
     * @return \StructType\RecipientList
     */
    public function addToRecipient(\StructType\Recipient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recipient) {
            throw new \InvalidArgumentException(sprintf('The recipient property can only contain items of \StructType\Recipient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->recipient[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecipientList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
