<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for readCursorRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: If "start" or "end" is passed in "position", the value for "forward" is ignored. "start" will read from the start of the database going forward. "end" will read from the end of the database going backward. If you are making multiple
 * calls to readCursorRequest, "position" should either be "current" or not present after the first call.
 * @subpackage Structs
 */
class ReadCursorRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The cursor
     * @var int
     */
    public $cursor;
    /**
     * The forward
     * Meta informations extracted from the WSDL
     * - default: 1
     * @var bool
     */
    public $forward;
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - default: current
     * - minOccurs: 0
     * @var string
     */
    public $position;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * Constructor method for readCursorRequest
     * @uses ReadCursorRequest::setContainer()
     * @uses ReadCursorRequest::setCursor()
     * @uses ReadCursorRequest::setForward()
     * @uses ReadCursorRequest::setPosition()
     * @uses ReadCursorRequest::setCount()
     * @param string $container
     * @param int $cursor
     * @param bool $forward
     * @param string $position
     * @param int $count
     */
    public function __construct($container = null, $cursor = null, $forward = true, $position = 'current', $count = 0)
    {
        $this
            ->setContainer($container)
            ->setCursor($cursor)
            ->setForward($forward)
            ->setPosition($position)
            ->setCount($count);
    }
    /**
     * Get container value
     * @return string|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\ReadCursorRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get cursor value
     * @return int|null
     */
    public function getCursor()
    {
        return $this->cursor;
    }
    /**
     * Set cursor value
     * @param int $cursor
     * @return \StructType\ReadCursorRequest
     */
    public function setCursor($cursor = null)
    {
        // validation for constraint: int
        if (!is_null($cursor) && !is_numeric($cursor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cursor)), __LINE__);
        }
        $this->cursor = $cursor;
        return $this;
    }
    /**
     * Get forward value
     * @return bool|null
     */
    public function getForward()
    {
        return $this->forward;
    }
    /**
     * Set forward value
     * @param bool $forward
     * @return \StructType\ReadCursorRequest
     */
    public function setForward($forward = true)
    {
        // validation for constraint: boolean
        if (!is_null($forward) && !is_bool($forward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forward)), __LINE__);
        }
        $this->forward = $forward;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @uses \EnumType\CursorSeek::valueIsValid()
     * @uses \EnumType\CursorSeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position
     * @return \StructType\ReadCursorRequest
     */
    public function setPosition($position = 'current')
    {
        // validation for constraint: enumeration
        if (!\EnumType\CursorSeek::valueIsValid($position)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $position, implode(', ', \EnumType\CursorSeek::getValidValues())), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\ReadCursorRequest
     */
    public function setCount($count = 0)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadCursorRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
