<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryTarget StructType
 * @subpackage Structs
 */
class QueryTarget extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string[]
     */
    public $container;
    /**
     * The source
     * @var string
     */
    public $source;
    /**
     * The info
     * @var \StructType\UserInfo
     */
    public $info;
    /**
     * Constructor method for QueryTarget
     * @uses QueryTarget::setContainer()
     * @uses QueryTarget::setSource()
     * @uses QueryTarget::setInfo()
     * @param string[] $container
     * @param string $source
     * @param \StructType\UserInfo $info
     */
    public function __construct(array $container = array(), $source = null, \StructType\UserInfo $info = null)
    {
        $this
            ->setContainer($container)
            ->setSource($source)
            ->setInfo($info);
    }
    /**
     * Get container value
     * @return string[]
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @throws \InvalidArgumentException
     * @param string[] $container
     * @return \StructType\QueryTarget
     */
    public function setContainer(array $container = array())
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        foreach ($container as $queryTargetContainerItem) {
            // validation for constraint: itemType
            if (!is_string($queryTargetContainerItem)) {
                throw new \InvalidArgumentException(sprintf('The container property can only contain items of string, "%s" given', is_object($queryTargetContainerItem) ? get_class($queryTargetContainerItem) : gettype($queryTargetContainerItem)), __LINE__);
            }
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Add item to container value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\QueryTarget
     */
    public function addToContainer($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[^@]+(@*)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The container property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->container[] = $item;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @uses \EnumType\SourceType::valueIsValid()
     * @uses \EnumType\SourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\QueryTarget
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SourceType::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\SourceType::getValidValues())), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get info value
     * @return \StructType\UserInfo|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param \StructType\UserInfo $info
     * @return \StructType\QueryTarget
     */
    public function setInfo(\StructType\UserInfo $info = null)
    {
        $this->info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryTarget
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
