<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryFolder StructType
 * @subpackage Structs
 */
class QueryFolder extends Folder
{
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The query
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Query
     */
    public $query;
    /**
     * Constructor method for QueryFolder
     * @uses QueryFolder::setFolderType()
     * @uses QueryFolder::setQuery()
     * @param string $folderType
     * @param \StructType\Query $query
     */
    public function __construct($folderType = null, \StructType\Query $query = null)
    {
        $this
            ->setFolderType($folderType)
            ->setQuery($query);
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderType::valueIsValid()
     * @uses \EnumType\FolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\QueryFolder
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\FolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get query value
     * @return \StructType\Query|null
     */
    public function getQuery()
    {
        return $this->query;
    }
    /**
     * Set query value
     * @param \StructType\Query $query
     * @return \StructType\QueryFolder
     */
    public function setQuery(\StructType\Query $query = null)
    {
        $this->query = $query;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
