<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Query StructType
 * @subpackage Structs
 */
class Query extends AbstractStructBase
{
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\QueryTargetList
     */
    public $target;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $filter;
    /**
     * Constructor method for Query
     * @uses Query::setTarget()
     * @uses Query::setFilter()
     * @param \StructType\QueryTargetList $target
     * @param \StructType\Filter $filter
     */
    public function __construct(\StructType\QueryTargetList $target = null, \StructType\Filter $filter = null)
    {
        $this
            ->setTarget($target)
            ->setFilter($filter);
    }
    /**
     * Get target value
     * @return \StructType\QueryTargetList|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \StructType\QueryTargetList $target
     * @return \StructType\Query
     */
    public function setTarget(\StructType\QueryTargetList $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\Filter $filter
     * @return \StructType\Query
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Query
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
