<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemEntry StructType
 * @subpackage Structs
 */
class ProblemEntry extends AbstractStructBase
{
    /**
     * The element
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $element;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:code
     * @var int
     */
    public $code;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * Constructor method for ProblemEntry
     * @uses ProblemEntry::setElement()
     * @uses ProblemEntry::setCode()
     * @uses ProblemEntry::setDescription()
     * @param string $element
     * @param int $code
     * @param string $description
     */
    public function __construct($element = null, $code = null, $description = null)
    {
        $this
            ->setElement($element)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get element value
     * @return string|null
     */
    public function getElement()
    {
        return $this->element;
    }
    /**
     * Set element value
     * @param string $element
     * @return \StructType\ProblemEntry
     */
    public function setElement($element = null)
    {
        // validation for constraint: string
        if (!is_null($element) && !is_string($element)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($element)), __LINE__);
        }
        $this->element = $element;
        return $this;
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\ProblemEntry
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProblemEntry
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProblemEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
