<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalAddressList StructType
 * @subpackage Structs
 */
class PostalAddressList extends AbstractStructBase
{
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PostalAddress[]
     */
    public $address;
    /**
     * The mailingAddress
     * @var string
     */
    public $mailingAddress;
    /**
     * Constructor method for PostalAddressList
     * @uses PostalAddressList::setAddress()
     * @uses PostalAddressList::setMailingAddress()
     * @param \StructType\PostalAddress[] $address
     * @param string $mailingAddress
     */
    public function __construct(array $address = array(), $mailingAddress = null)
    {
        $this
            ->setAddress($address)
            ->setMailingAddress($mailingAddress);
    }
    /**
     * Get address value
     * @return \StructType\PostalAddress[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \StructType\PostalAddress[] $address
     * @return \StructType\PostalAddressList
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $postalAddressListAddressItem) {
            // validation for constraint: itemType
            if (!$postalAddressListAddressItem instanceof \StructType\PostalAddress) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\PostalAddress, "%s" given', is_object($postalAddressListAddressItem) ? get_class($postalAddressListAddressItem) : gettype($postalAddressListAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \StructType\PostalAddress $item
     * @return \StructType\PostalAddressList
     */
    public function addToAddress(\StructType\PostalAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PostalAddress) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of \StructType\PostalAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get mailingAddress value
     * @return string|null
     */
    public function getMailingAddress()
    {
        return $this->mailingAddress;
    }
    /**
     * Set mailingAddress value
     * @uses \EnumType\PostalAddressType::valueIsValid()
     * @uses \EnumType\PostalAddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mailingAddress
     * @return \StructType\PostalAddressList
     */
    public function setMailingAddress($mailingAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostalAddressType::valueIsValid($mailingAddress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mailingAddress, implode(', ', \EnumType\PostalAddressType::getValidValues())), __LINE__);
        }
        $this->mailingAddress = $mailingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalAddressList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
