<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalAddress StructType
 * @subpackage Structs
 */
class PostalAddress extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The streetAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $streetAddress;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $location;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The postalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The poBox
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poBox;
    /**
     * Constructor method for PostalAddress
     * @uses PostalAddress::setType()
     * @uses PostalAddress::setDescription()
     * @uses PostalAddress::setStreetAddress()
     * @uses PostalAddress::setLocation()
     * @uses PostalAddress::setCity()
     * @uses PostalAddress::setState()
     * @uses PostalAddress::setPostalCode()
     * @uses PostalAddress::setCountry()
     * @uses PostalAddress::setPoBox()
     * @param string $type
     * @param string $description
     * @param string $streetAddress
     * @param string $location
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string $country
     * @param string $poBox
     */
    public function __construct($type = null, $description = null, $streetAddress = null, $location = null, $city = null, $state = null, $postalCode = null, $country = null, $poBox = null)
    {
        $this
            ->setType($type)
            ->setDescription($description)
            ->setStreetAddress($streetAddress)
            ->setLocation($location)
            ->setCity($city)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setPoBox($poBox);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\PostalAddressType::valueIsValid()
     * @uses \EnumType\PostalAddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PostalAddress
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostalAddressType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\PostalAddressType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PostalAddress
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get streetAddress value
     * @return string|null
     */
    public function getStreetAddress()
    {
        return $this->streetAddress;
    }
    /**
     * Set streetAddress value
     * @param string $streetAddress
     * @return \StructType\PostalAddress
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAddress)), __LINE__);
        }
        $this->streetAddress = $streetAddress;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\PostalAddress
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PostalAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\PostalAddress
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\PostalAddress
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\PostalAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get poBox value
     * @return string|null
     */
    public function getPoBox()
    {
        return $this->poBox;
    }
    /**
     * Set poBox value
     * @param string $poBox
     * @return \StructType\PostalAddress
     */
    public function setPoBox($poBox = null)
    {
        // validation for constraint: string
        if (!is_null($poBox) && !is_string($poBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poBox)), __LINE__);
        }
        $this->poBox = $poBox;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
