<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pollRequest StructType
 * @subpackage Structs
 */
class PollRequest extends AbstractStructBase
{
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sequence;
    /**
     * The notify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PollNotify
     */
    public $notify;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * Constructor method for pollRequest
     * @uses PollRequest::setSequence()
     * @uses PollRequest::setNotify()
     * @uses PollRequest::setView()
     * @param int $sequence
     * @param \StructType\PollNotify $notify
     * @param string $view
     */
    public function __construct($sequence = null, \StructType\PollNotify $notify = null, $view = null)
    {
        $this
            ->setSequence($sequence)
            ->setNotify($notify)
            ->setView($view);
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\PollRequest
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get notify value
     * @return \StructType\PollNotify|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param \StructType\PollNotify $notify
     * @return \StructType\PollRequest
     */
    public function setNotify(\StructType\PollNotify $notify = null)
    {
        $this->notify = $notify;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\PollRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
