<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Nickname StructType
 * @subpackage Structs
 */
class Nickname extends AddressBookItem
{
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The realType
     * Meta informations extracted from the WSDL
     * - default: Contact
     * - minOccurs: 0
     * @var string
     */
    public $realType;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Owner
     */
    public $owner;
    /**
     * Constructor method for Nickname
     * @uses Nickname::setEmail()
     * @uses Nickname::setRealType()
     * @uses Nickname::setOwner()
     * @param string $email
     * @param string $realType
     * @param \StructType\Owner $owner
     */
    public function __construct($email = null, $realType = 'Contact', \StructType\Owner $owner = null)
    {
        $this
            ->setEmail($email)
            ->setRealType($realType)
            ->setOwner($owner);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Nickname
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get realType value
     * @return string|null
     */
    public function getRealType()
    {
        return $this->realType;
    }
    /**
     * Set realType value
     * @uses \EnumType\ContactType::valueIsValid()
     * @uses \EnumType\ContactType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $realType
     * @return \StructType\Nickname
     */
    public function setRealType($realType = 'Contact')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactType::valueIsValid($realType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $realType, implode(', ', \EnumType\ContactType::getValidValues())), __LINE__);
        }
        $this->realType = $realType;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\Owner|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\Owner $owner
     * @return \StructType\Nickname
     */
    public function setOwner(\StructType\Owner $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Nickname
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
