<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NNTP StructType
 * @subpackage Structs
 */
class NNTP extends Account
{
    /**
     * The folder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $folder;
    /**
     * The inbound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Server
     */
    public $inbound;
    /**
     * The outbound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Server
     */
    public $outbound;
    /**
     * The life
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $life;
    /**
     * The maxMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxMessages;
    /**
     * The newMessagesXDaysOld
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $newMessagesXDaysOld;
    /**
     * Constructor method for NNTP
     * @uses NNTP::setFolder()
     * @uses NNTP::setInbound()
     * @uses NNTP::setOutbound()
     * @uses NNTP::setLife()
     * @uses NNTP::setMaxMessages()
     * @uses NNTP::setNewMessagesXDaysOld()
     * @param string $folder
     * @param \StructType\Server $inbound
     * @param \StructType\Server $outbound
     * @param int $life
     * @param int $maxMessages
     * @param int $newMessagesXDaysOld
     */
    public function __construct($folder = null, \StructType\Server $inbound = null, \StructType\Server $outbound = null, $life = null, $maxMessages = null, $newMessagesXDaysOld = null)
    {
        $this
            ->setFolder($folder)
            ->setInbound($inbound)
            ->setOutbound($outbound)
            ->setLife($life)
            ->setMaxMessages($maxMessages)
            ->setNewMessagesXDaysOld($newMessagesXDaysOld);
    }
    /**
     * Get folder value
     * @return string
     */
    public function getFolder()
    {
        return $this->folder;
    }
    /**
     * Set folder value
     * @param string $folder
     * @return \StructType\NNTP
     */
    public function setFolder($folder = null)
    {
        // validation for constraint: pattern
        if (is_scalar($folder) && !preg_match('/[^@]+(@*)?/', $folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($folder, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($folder) && !is_string($folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($folder)), __LINE__);
        }
        $this->folder = $folder;
        return $this;
    }
    /**
     * Get inbound value
     * @return \StructType\Server|null
     */
    public function getInbound()
    {
        return $this->inbound;
    }
    /**
     * Set inbound value
     * @param \StructType\Server $inbound
     * @return \StructType\NNTP
     */
    public function setInbound(\StructType\Server $inbound = null)
    {
        $this->inbound = $inbound;
        return $this;
    }
    /**
     * Get outbound value
     * @return \StructType\Server|null
     */
    public function getOutbound()
    {
        return $this->outbound;
    }
    /**
     * Set outbound value
     * @param \StructType\Server $outbound
     * @return \StructType\NNTP
     */
    public function setOutbound(\StructType\Server $outbound = null)
    {
        $this->outbound = $outbound;
        return $this;
    }
    /**
     * Get life value
     * @return int|null
     */
    public function getLife()
    {
        return $this->life;
    }
    /**
     * Set life value
     * @param int $life
     * @return \StructType\NNTP
     */
    public function setLife($life = null)
    {
        // validation for constraint: int
        if (!is_null($life) && !is_numeric($life)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($life)), __LINE__);
        }
        $this->life = $life;
        return $this;
    }
    /**
     * Get maxMessages value
     * @return int|null
     */
    public function getMaxMessages()
    {
        return $this->maxMessages;
    }
    /**
     * Set maxMessages value
     * @param int $maxMessages
     * @return \StructType\NNTP
     */
    public function setMaxMessages($maxMessages = null)
    {
        // validation for constraint: int
        if (!is_null($maxMessages) && !is_numeric($maxMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxMessages)), __LINE__);
        }
        $this->maxMessages = $maxMessages;
        return $this;
    }
    /**
     * Get newMessagesXDaysOld value
     * @return int|null
     */
    public function getNewMessagesXDaysOld()
    {
        return $this->newMessagesXDaysOld;
    }
    /**
     * Set newMessagesXDaysOld value
     * @param int $newMessagesXDaysOld
     * @return \StructType\NNTP
     */
    public function setNewMessagesXDaysOld($newMessagesXDaysOld = null)
    {
        // validation for constraint: int
        if (!is_null($newMessagesXDaysOld) && !is_numeric($newMessagesXDaysOld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newMessagesXDaysOld)), __LINE__);
        }
        $this->newMessagesXDaysOld = $newMessagesXDaysOld;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NNTP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
