<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moveItemsRequest StructType
 * @subpackage Structs
 */
class MoveItemsRequest extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MoveItem[]
     */
    public $item;
    /**
     * Constructor method for moveItemsRequest
     * @uses MoveItemsRequest::setItem()
     * @param \StructType\MoveItem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\MoveItem[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\MoveItem[] $item
     * @return \StructType\MoveItemsRequest
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $moveItemsRequestItemItem) {
            // validation for constraint: itemType
            if (!$moveItemsRequestItemItem instanceof \StructType\MoveItem) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\MoveItem, "%s" given', is_object($moveItemsRequestItemItem) ? get_class($moveItemsRequestItemItem) : gettype($moveItemsRequestItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\MoveItem $item
     * @return \StructType\MoveItemsRequest
     */
    public function addToItem(\StructType\MoveItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MoveItem) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\MoveItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoveItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
