<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for modifyNotifyRequest StructType
 * @subpackage Structs
 */
class ModifyNotifyRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The updates
     * @var \StructType\NotifyEntryChanges
     */
    public $updates;
    /**
     * Constructor method for modifyNotifyRequest
     * @uses ModifyNotifyRequest::setId()
     * @uses ModifyNotifyRequest::setUpdates()
     * @param string $id
     * @param \StructType\NotifyEntryChanges $updates
     */
    public function __construct($id = null, \StructType\NotifyEntryChanges $updates = null)
    {
        $this
            ->setId($id)
            ->setUpdates($updates);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ModifyNotifyRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get updates value
     * @return \StructType\NotifyEntryChanges|null
     */
    public function getUpdates()
    {
        return $this->updates;
    }
    /**
     * Set updates value
     * @param \StructType\NotifyEntryChanges $updates
     * @return \StructType\ModifyNotifyRequest
     */
    public function setUpdates(\StructType\NotifyEntryChanges $updates = null)
    {
        $this->updates = $updates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifyNotifyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
