<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessagePart StructType
 * Meta informations extracted from the WSDL
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class MessagePart extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The contentId
     * @var string
     */
    public $contentId;
    /**
     * The contentType
     * Meta informations extracted from the WSDL
     * - default: text/plain
     * - use: optional
     * @var string
     */
    public $contentType;
    /**
     * The length
     * Meta informations extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $length;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - default: 0
     * - use: optional
     * @var int
     */
    public $offset;
    /**
     * The hash
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $hash;
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $path;
    /**
     * Constructor method for MessagePart
     * @uses MessagePart::set_()
     * @uses MessagePart::setId()
     * @uses MessagePart::setContentId()
     * @uses MessagePart::setContentType()
     * @uses MessagePart::setLength()
     * @uses MessagePart::setOffset()
     * @uses MessagePart::setHash()
     * @uses MessagePart::setPath()
     * @param string $_
     * @param string $id
     * @param string $contentId
     * @param string $contentType
     * @param int $length
     * @param int $offset
     * @param string $hash
     * @param string $path
     */
    public function __construct($_ = null, $id = null, $contentId = null, $contentType = 'text/plain', $length = 0, $offset = 0, $hash = null, $path = null)
    {
        $this
            ->set_($_)
            ->setId($id)
            ->setContentId($contentId)
            ->setContentType($contentType)
            ->setLength($length)
            ->setOffset($offset)
            ->setHash($hash)
            ->setPath($path);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\MessagePart
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MessagePart
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get contentId value
     * @return string|null
     */
    public function getContentId()
    {
        return $this->contentId;
    }
    /**
     * Set contentId value
     * @param string $contentId
     * @return \StructType\MessagePart
     */
    public function setContentId($contentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentId) && !is_string($contentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentId)), __LINE__);
        }
        $this->contentId = $contentId;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\MessagePart
     */
    public function setContentType($contentType = 'text/plain')
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param int $length
     * @return \StructType\MessagePart
     */
    public function setLength($length = 0)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\MessagePart
     */
    public function setOffset($offset = 0)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\MessagePart
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \StructType\MessagePart
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessagePart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
