<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mail StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:dateTime
 * @subpackage Structs
 */
class Mail extends BoxEntry
{
    /**
     * The originalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $originalId;
    /**
     * The subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:subject
     * @var string
     */
    public $subject;
    /**
     * The originalSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $originalSubject;
    /**
     * The subjectPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subjectPrefix;
    /**
     * The distribution
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Distribution
     */
    public $distribution;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageBody
     */
    public $message;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentInfo
     */
    public $attachments;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptions
     */
    public $options;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LinkInfo[]
     */
    public $link;
    /**
     * The hasAttachment
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $hasAttachment;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $size;
    /**
     * The subType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subType;
    /**
     * The nntpOrImap
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $nntpOrImap;
    /**
     * The smimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SMimeOperation
     */
    public $smimeType;
    /**
     * The checklist
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ChecklistInfo
     */
    public $checklist;
    /**
     * The xField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $xField;
    /**
     * The archiveId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $archiveId;
    /**
     * The threading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemThreading
     */
    public $threading;
    /**
     * The retentionModified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retentionModified;
    /**
     * The rssURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rssURL;
    /**
     * The junkMailEvaluation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TextLines
     */
    public $junkMailEvaluation;
    /**
     * The junkMailSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TextLines
     */
    public $junkMailSettings;
    /**
     * The globalSignatureInternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $globalSignatureInternalId;
    /**
     * The totals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SendTotals
     */
    public $totals;
    /**
     * The internet
     * @var bool
     */
    public $internet;
    /**
     * The stub
     * @var bool
     */
    public $stub;
    /**
     * The mime
     * @var bool
     */
    public $mime;
    /**
     * Constructor method for Mail
     * @uses Mail::setOriginalId()
     * @uses Mail::setSubject()
     * @uses Mail::setOriginalSubject()
     * @uses Mail::setSubjectPrefix()
     * @uses Mail::setDistribution()
     * @uses Mail::setMessage()
     * @uses Mail::setAttachments()
     * @uses Mail::setOptions()
     * @uses Mail::setLink()
     * @uses Mail::setHasAttachment()
     * @uses Mail::setSize()
     * @uses Mail::setSubType()
     * @uses Mail::setNntpOrImap()
     * @uses Mail::setSmimeType()
     * @uses Mail::setChecklist()
     * @uses Mail::setXField()
     * @uses Mail::setArchiveId()
     * @uses Mail::setThreading()
     * @uses Mail::setRetentionModified()
     * @uses Mail::setRssURL()
     * @uses Mail::setJunkMailEvaluation()
     * @uses Mail::setJunkMailSettings()
     * @uses Mail::setGlobalSignatureInternalId()
     * @uses Mail::setTotals()
     * @uses Mail::setInternet()
     * @uses Mail::setStub()
     * @uses Mail::setMime()
     * @param string $originalId
     * @param string $subject
     * @param string $originalSubject
     * @param string $subjectPrefix
     * @param \StructType\Distribution $distribution
     * @param \StructType\MessageBody $message
     * @param \StructType\AttachmentInfo $attachments
     * @param \StructType\ItemOptions $options
     * @param \StructType\LinkInfo[] $link
     * @param bool $hasAttachment
     * @param int $size
     * @param string $subType
     * @param bool $nntpOrImap
     * @param \StructType\SMimeOperation $smimeType
     * @param \StructType\ChecklistInfo $checklist
     * @param string[] $xField
     * @param string $archiveId
     * @param \StructType\ItemThreading $threading
     * @param string $retentionModified
     * @param string $rssURL
     * @param \StructType\TextLines $junkMailEvaluation
     * @param \StructType\TextLines $junkMailSettings
     * @param string $globalSignatureInternalId
     * @param \StructType\SendTotals $totals
     * @param bool $internet
     * @param bool $stub
     * @param bool $mime
     */
    public function __construct($originalId = null, $subject = null, $originalSubject = null, $subjectPrefix = null, \StructType\Distribution $distribution = null, \StructType\MessageBody $message = null, \StructType\AttachmentInfo $attachments = null, \StructType\ItemOptions $options = null, array $link = array(), $hasAttachment = false, $size = 0, $subType = null, $nntpOrImap = null, \StructType\SMimeOperation $smimeType = null, \StructType\ChecklistInfo $checklist = null, array $xField = array(), $archiveId = null, \StructType\ItemThreading $threading = null, $retentionModified = null, $rssURL = null, \StructType\TextLines $junkMailEvaluation = null, \StructType\TextLines $junkMailSettings = null, $globalSignatureInternalId = null, \StructType\SendTotals $totals = null, $internet = null, $stub = null, $mime = null)
    {
        $this
            ->setOriginalId($originalId)
            ->setSubject($subject)
            ->setOriginalSubject($originalSubject)
            ->setSubjectPrefix($subjectPrefix)
            ->setDistribution($distribution)
            ->setMessage($message)
            ->setAttachments($attachments)
            ->setOptions($options)
            ->setLink($link)
            ->setHasAttachment($hasAttachment)
            ->setSize($size)
            ->setSubType($subType)
            ->setNntpOrImap($nntpOrImap)
            ->setSmimeType($smimeType)
            ->setChecklist($checklist)
            ->setXField($xField)
            ->setArchiveId($archiveId)
            ->setThreading($threading)
            ->setRetentionModified($retentionModified)
            ->setRssURL($rssURL)
            ->setJunkMailEvaluation($junkMailEvaluation)
            ->setJunkMailSettings($junkMailSettings)
            ->setGlobalSignatureInternalId($globalSignatureInternalId)
            ->setTotals($totals)
            ->setInternet($internet)
            ->setStub($stub)
            ->setMime($mime);
    }
    /**
     * Get originalId value
     * @return string
     */
    public function getOriginalId()
    {
        return $this->originalId;
    }
    /**
     * Set originalId value
     * @param string $originalId
     * @return \StructType\Mail
     */
    public function setOriginalId($originalId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($originalId) && !preg_match('/[^@]+(@*)?/', $originalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($originalId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($originalId) && !is_string($originalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalId)), __LINE__);
        }
        $this->originalId = $originalId;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\Mail
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get originalSubject value
     * @return string|null
     */
    public function getOriginalSubject()
    {
        return $this->originalSubject;
    }
    /**
     * Set originalSubject value
     * @param string $originalSubject
     * @return \StructType\Mail
     */
    public function setOriginalSubject($originalSubject = null)
    {
        // validation for constraint: string
        if (!is_null($originalSubject) && !is_string($originalSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originalSubject)), __LINE__);
        }
        $this->originalSubject = $originalSubject;
        return $this;
    }
    /**
     * Get subjectPrefix value
     * @return string|null
     */
    public function getSubjectPrefix()
    {
        return $this->subjectPrefix;
    }
    /**
     * Set subjectPrefix value
     * @param string $subjectPrefix
     * @return \StructType\Mail
     */
    public function setSubjectPrefix($subjectPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($subjectPrefix) && !is_string($subjectPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subjectPrefix)), __LINE__);
        }
        $this->subjectPrefix = $subjectPrefix;
        return $this;
    }
    /**
     * Get distribution value
     * @return \StructType\Distribution|null
     */
    public function getDistribution()
    {
        return $this->distribution;
    }
    /**
     * Set distribution value
     * @param \StructType\Distribution $distribution
     * @return \StructType\Mail
     */
    public function setDistribution(\StructType\Distribution $distribution = null)
    {
        $this->distribution = $distribution;
        return $this;
    }
    /**
     * Get message value
     * @return \StructType\MessageBody|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param \StructType\MessageBody $message
     * @return \StructType\Mail
     */
    public function setMessage(\StructType\MessageBody $message = null)
    {
        $this->message = $message;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentInfo|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentInfo $attachments
     * @return \StructType\Mail
     */
    public function setAttachments(\StructType\AttachmentInfo $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\ItemOptions|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \StructType\ItemOptions $options
     * @return \StructType\Mail
     */
    public function setOptions(\StructType\ItemOptions $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\LinkInfo[]|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkInfo[] $link
     * @return \StructType\Mail
     */
    public function setLink(array $link = array())
    {
        foreach ($link as $mailLinkItem) {
            // validation for constraint: itemType
            if (!$mailLinkItem instanceof \StructType\LinkInfo) {
                throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\LinkInfo, "%s" given', is_object($mailLinkItem) ? get_class($mailLinkItem) : gettype($mailLinkItem)), __LINE__);
            }
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Add item to link value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkInfo $item
     * @return \StructType\Mail
     */
    public function addToLink(\StructType\LinkInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinkInfo) {
            throw new \InvalidArgumentException(sprintf('The link property can only contain items of \StructType\LinkInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->link[] = $item;
        return $this;
    }
    /**
     * Get hasAttachment value
     * @return bool|null
     */
    public function getHasAttachment()
    {
        return $this->hasAttachment;
    }
    /**
     * Set hasAttachment value
     * @param bool $hasAttachment
     * @return \StructType\Mail
     */
    public function setHasAttachment($hasAttachment = false)
    {
        // validation for constraint: boolean
        if (!is_null($hasAttachment) && !is_bool($hasAttachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasAttachment)), __LINE__);
        }
        $this->hasAttachment = $hasAttachment;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\Mail
     */
    public function setSize($size = 0)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get subType value
     * @return string|null
     */
    public function getSubType()
    {
        return $this->subType;
    }
    /**
     * Set subType value
     * @param string $subType
     * @return \StructType\Mail
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subType)), __LINE__);
        }
        $this->subType = $subType;
        return $this;
    }
    /**
     * Get nntpOrImap value
     * @return bool|null
     */
    public function getNntpOrImap()
    {
        return $this->nntpOrImap;
    }
    /**
     * Set nntpOrImap value
     * @param bool $nntpOrImap
     * @return \StructType\Mail
     */
    public function setNntpOrImap($nntpOrImap = null)
    {
        // validation for constraint: boolean
        if (!is_null($nntpOrImap) && !is_bool($nntpOrImap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nntpOrImap)), __LINE__);
        }
        $this->nntpOrImap = $nntpOrImap;
        return $this;
    }
    /**
     * Get smimeType value
     * @return \StructType\SMimeOperation|null
     */
    public function getSmimeType()
    {
        return $this->smimeType;
    }
    /**
     * Set smimeType value
     * @param \StructType\SMimeOperation $smimeType
     * @return \StructType\Mail
     */
    public function setSmimeType(\StructType\SMimeOperation $smimeType = null)
    {
        $this->smimeType = $smimeType;
        return $this;
    }
    /**
     * Get checklist value
     * @return \StructType\ChecklistInfo|null
     */
    public function getChecklist()
    {
        return $this->checklist;
    }
    /**
     * Set checklist value
     * @param \StructType\ChecklistInfo $checklist
     * @return \StructType\Mail
     */
    public function setChecklist(\StructType\ChecklistInfo $checklist = null)
    {
        $this->checklist = $checklist;
        return $this;
    }
    /**
     * Get xField value
     * @return string[]|null
     */
    public function getXField()
    {
        return $this->xField;
    }
    /**
     * Set xField value
     * @throws \InvalidArgumentException
     * @param string[] $xField
     * @return \StructType\Mail
     */
    public function setXField(array $xField = array())
    {
        foreach ($xField as $mailXFieldItem) {
            // validation for constraint: itemType
            if (!is_string($mailXFieldItem)) {
                throw new \InvalidArgumentException(sprintf('The xField property can only contain items of string, "%s" given', is_object($mailXFieldItem) ? get_class($mailXFieldItem) : gettype($mailXFieldItem)), __LINE__);
            }
        }
        $this->xField = $xField;
        return $this;
    }
    /**
     * Add item to xField value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Mail
     */
    public function addToXField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The xField property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->xField[] = $item;
        return $this;
    }
    /**
     * Get archiveId value
     * @return string|null
     */
    public function getArchiveId()
    {
        return $this->archiveId;
    }
    /**
     * Set archiveId value
     * @param string $archiveId
     * @return \StructType\Mail
     */
    public function setArchiveId($archiveId = null)
    {
        // validation for constraint: string
        if (!is_null($archiveId) && !is_string($archiveId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($archiveId)), __LINE__);
        }
        $this->archiveId = $archiveId;
        return $this;
    }
    /**
     * Get threading value
     * @return \StructType\ItemThreading|null
     */
    public function getThreading()
    {
        return $this->threading;
    }
    /**
     * Set threading value
     * @param \StructType\ItemThreading $threading
     * @return \StructType\Mail
     */
    public function setThreading(\StructType\ItemThreading $threading = null)
    {
        $this->threading = $threading;
        return $this;
    }
    /**
     * Get retentionModified value
     * @return string|null
     */
    public function getRetentionModified()
    {
        return $this->retentionModified;
    }
    /**
     * Set retentionModified value
     * @param string $retentionModified
     * @return \StructType\Mail
     */
    public function setRetentionModified($retentionModified = null)
    {
        // validation for constraint: string
        if (!is_null($retentionModified) && !is_string($retentionModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retentionModified)), __LINE__);
        }
        $this->retentionModified = $retentionModified;
        return $this;
    }
    /**
     * Get rssURL value
     * @return string|null
     */
    public function getRssURL()
    {
        return $this->rssURL;
    }
    /**
     * Set rssURL value
     * @param string $rssURL
     * @return \StructType\Mail
     */
    public function setRssURL($rssURL = null)
    {
        // validation for constraint: string
        if (!is_null($rssURL) && !is_string($rssURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rssURL)), __LINE__);
        }
        $this->rssURL = $rssURL;
        return $this;
    }
    /**
     * Get junkMailEvaluation value
     * @return \StructType\TextLines|null
     */
    public function getJunkMailEvaluation()
    {
        return $this->junkMailEvaluation;
    }
    /**
     * Set junkMailEvaluation value
     * @param \StructType\TextLines $junkMailEvaluation
     * @return \StructType\Mail
     */
    public function setJunkMailEvaluation(\StructType\TextLines $junkMailEvaluation = null)
    {
        $this->junkMailEvaluation = $junkMailEvaluation;
        return $this;
    }
    /**
     * Get junkMailSettings value
     * @return \StructType\TextLines|null
     */
    public function getJunkMailSettings()
    {
        return $this->junkMailSettings;
    }
    /**
     * Set junkMailSettings value
     * @param \StructType\TextLines $junkMailSettings
     * @return \StructType\Mail
     */
    public function setJunkMailSettings(\StructType\TextLines $junkMailSettings = null)
    {
        $this->junkMailSettings = $junkMailSettings;
        return $this;
    }
    /**
     * Get globalSignatureInternalId value
     * @return string|null
     */
    public function getGlobalSignatureInternalId()
    {
        return $this->globalSignatureInternalId;
    }
    /**
     * Set globalSignatureInternalId value
     * @param string $globalSignatureInternalId
     * @return \StructType\Mail
     */
    public function setGlobalSignatureInternalId($globalSignatureInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($globalSignatureInternalId) && !is_string($globalSignatureInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($globalSignatureInternalId)), __LINE__);
        }
        $this->globalSignatureInternalId = $globalSignatureInternalId;
        return $this;
    }
    /**
     * Get totals value
     * @return \StructType\SendTotals|null
     */
    public function getTotals()
    {
        return $this->totals;
    }
    /**
     * Set totals value
     * @param \StructType\SendTotals $totals
     * @return \StructType\Mail
     */
    public function setTotals(\StructType\SendTotals $totals = null)
    {
        $this->totals = $totals;
        return $this;
    }
    /**
     * Get internet value
     * @return bool|null
     */
    public function getInternet()
    {
        return $this->internet;
    }
    /**
     * Set internet value
     * @param bool $internet
     * @return \StructType\Mail
     */
    public function setInternet($internet = null)
    {
        // validation for constraint: boolean
        if (!is_null($internet) && !is_bool($internet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($internet)), __LINE__);
        }
        $this->internet = $internet;
        return $this;
    }
    /**
     * Get stub value
     * @return bool|null
     */
    public function getStub()
    {
        return $this->stub;
    }
    /**
     * Set stub value
     * @param bool $stub
     * @return \StructType\Mail
     */
    public function setStub($stub = null)
    {
        // validation for constraint: boolean
        if (!is_null($stub) && !is_bool($stub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($stub)), __LINE__);
        }
        $this->stub = $stub;
        return $this;
    }
    /**
     * Get mime value
     * @return bool|null
     */
    public function getMime()
    {
        return $this->mime;
    }
    /**
     * Set mime value
     * @param bool $mime
     * @return \StructType\Mail
     */
    public function setMime($mime = null)
    {
        // validation for constraint: boolean
        if (!is_null($mime) && !is_bool($mime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mime)), __LINE__);
        }
        $this->mime = $mime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
