<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupTable StructType
 * @subpackage Structs
 */
class LookupTable extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $value;
    /**
     * Constructor method for LookupTable
     * @uses LookupTable::setName()
     * @uses LookupTable::setId()
     * @uses LookupTable::setValue()
     * @param string $name
     * @param string $id
     * @param string[] $value
     */
    public function __construct($name = null, $id = null, array $value = array())
    {
        $this
            ->setName($name)
            ->setId($id)
            ->setValue($value);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LookupTable
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\LookupTable
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get value value
     * @return string[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param string[] $value
     * @return \StructType\LookupTable
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $lookupTableValueItem) {
            // validation for constraint: itemType
            if (!is_string($lookupTableValueItem)) {
                throw new \InvalidArgumentException(sprintf('The value property can only contain items of string, "%s" given', is_object($lookupTableValueItem) ? get_class($lookupTableValueItem) : gettype($lookupTableValueItem)), __LINE__);
            }
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LookupTable
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LookupTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
