<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loginResponse StructType
 * @subpackage Structs
 */
class LoginResponse extends AbstractStructBase
{
    /**
     * The session
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $session;
    /**
     * The userinfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UserInfo
     */
    public $userinfo;
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessRightEntry
     */
    public $entry;
    /**
     * The gwVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gwVersion;
    /**
     * The build
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $build;
    /**
     * The redirectToHost
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Host[]
     */
    public $redirectToHost;
    /**
     * The serverUTCTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serverUTCTime;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for loginResponse
     * @uses LoginResponse::setSession()
     * @uses LoginResponse::setUserinfo()
     * @uses LoginResponse::setEntry()
     * @uses LoginResponse::setGwVersion()
     * @uses LoginResponse::setBuild()
     * @uses LoginResponse::setRedirectToHost()
     * @uses LoginResponse::setServerUTCTime()
     * @uses LoginResponse::setStatus()
     * @param string $session
     * @param \StructType\UserInfo $userinfo
     * @param \StructType\AccessRightEntry $entry
     * @param string $gwVersion
     * @param string $build
     * @param \StructType\Host[] $redirectToHost
     * @param string $serverUTCTime
     * @param \StructType\Status $status
     */
    public function __construct($session = null, \StructType\UserInfo $userinfo = null, \StructType\AccessRightEntry $entry = null, $gwVersion = null, $build = null, array $redirectToHost = array(), $serverUTCTime = null, \StructType\Status $status = null)
    {
        $this
            ->setSession($session)
            ->setUserinfo($userinfo)
            ->setEntry($entry)
            ->setGwVersion($gwVersion)
            ->setBuild($build)
            ->setRedirectToHost($redirectToHost)
            ->setServerUTCTime($serverUTCTime)
            ->setStatus($status);
    }
    /**
     * Get session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param string $session
     * @return \StructType\LoginResponse
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get userinfo value
     * @return \StructType\UserInfo|null
     */
    public function getUserinfo()
    {
        return $this->userinfo;
    }
    /**
     * Set userinfo value
     * @param \StructType\UserInfo $userinfo
     * @return \StructType\LoginResponse
     */
    public function setUserinfo(\StructType\UserInfo $userinfo = null)
    {
        $this->userinfo = $userinfo;
        return $this;
    }
    /**
     * Get entry value
     * @return \StructType\AccessRightEntry|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @param \StructType\AccessRightEntry $entry
     * @return \StructType\LoginResponse
     */
    public function setEntry(\StructType\AccessRightEntry $entry = null)
    {
        $this->entry = $entry;
        return $this;
    }
    /**
     * Get gwVersion value
     * @return string|null
     */
    public function getGwVersion()
    {
        return $this->gwVersion;
    }
    /**
     * Set gwVersion value
     * @param string $gwVersion
     * @return \StructType\LoginResponse
     */
    public function setGwVersion($gwVersion = null)
    {
        // validation for constraint: string
        if (!is_null($gwVersion) && !is_string($gwVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gwVersion)), __LINE__);
        }
        $this->gwVersion = $gwVersion;
        return $this;
    }
    /**
     * Get build value
     * @return string|null
     */
    public function getBuild()
    {
        return $this->build;
    }
    /**
     * Set build value
     * @param string $build
     * @return \StructType\LoginResponse
     */
    public function setBuild($build = null)
    {
        // validation for constraint: string
        if (!is_null($build) && !is_string($build)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($build)), __LINE__);
        }
        $this->build = $build;
        return $this;
    }
    /**
     * Get redirectToHost value
     * @return \StructType\Host[]|null
     */
    public function getRedirectToHost()
    {
        return $this->redirectToHost;
    }
    /**
     * Set redirectToHost value
     * @throws \InvalidArgumentException
     * @param \StructType\Host[] $redirectToHost
     * @return \StructType\LoginResponse
     */
    public function setRedirectToHost(array $redirectToHost = array())
    {
        foreach ($redirectToHost as $loginResponseRedirectToHostItem) {
            // validation for constraint: itemType
            if (!$loginResponseRedirectToHostItem instanceof \StructType\Host) {
                throw new \InvalidArgumentException(sprintf('The redirectToHost property can only contain items of \StructType\Host, "%s" given', is_object($loginResponseRedirectToHostItem) ? get_class($loginResponseRedirectToHostItem) : gettype($loginResponseRedirectToHostItem)), __LINE__);
            }
        }
        $this->redirectToHost = $redirectToHost;
        return $this;
    }
    /**
     * Add item to redirectToHost value
     * @throws \InvalidArgumentException
     * @param \StructType\Host $item
     * @return \StructType\LoginResponse
     */
    public function addToRedirectToHost(\StructType\Host $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Host) {
            throw new \InvalidArgumentException(sprintf('The redirectToHost property can only contain items of \StructType\Host, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->redirectToHost[] = $item;
        return $this;
    }
    /**
     * Get serverUTCTime value
     * @return string|null
     */
    public function getServerUTCTime()
    {
        return $this->serverUTCTime;
    }
    /**
     * Set serverUTCTime value
     * @param string $serverUTCTime
     * @return \StructType\LoginResponse
     */
    public function setServerUTCTime($serverUTCTime = null)
    {
        // validation for constraint: string
        if (!is_null($serverUTCTime) && !is_string($serverUTCTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverUTCTime)), __LINE__);
        }
        $this->serverUTCTime = $serverUTCTime;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\LoginResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
