<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkInfo StructType
 * @subpackage Structs
 */
class LinkInfo extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The thread
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thread;
    /**
     * The copyAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $copyAttachments;
    /**
     * Constructor method for LinkInfo
     * @uses LinkInfo::setId()
     * @uses LinkInfo::setType()
     * @uses LinkInfo::setThread()
     * @uses LinkInfo::setCopyAttachments()
     * @param string $id
     * @param string $type
     * @param string $thread
     * @param bool $copyAttachments
     */
    public function __construct($id = null, $type = null, $thread = null, $copyAttachments = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setThread($thread)
            ->setCopyAttachments($copyAttachments);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\LinkInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\LinkType::valueIsValid()
     * @uses \EnumType\LinkType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\LinkInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LinkType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\LinkType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get thread value
     * @return string|null
     */
    public function getThread()
    {
        return $this->thread;
    }
    /**
     * Set thread value
     * @param string $thread
     * @return \StructType\LinkInfo
     */
    public function setThread($thread = null)
    {
        // validation for constraint: string
        if (!is_null($thread) && !is_string($thread)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thread)), __LINE__);
        }
        $this->thread = $thread;
        return $this;
    }
    /**
     * Get copyAttachments value
     * @return bool|null
     */
    public function getCopyAttachments()
    {
        return $this->copyAttachments;
    }
    /**
     * Set copyAttachments value
     * @param bool $copyAttachments
     * @return \StructType\LinkInfo
     */
    public function setCopyAttachments($copyAttachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyAttachments) && !is_bool($copyAttachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($copyAttachments)), __LINE__);
        }
        $this->copyAttachments = $copyAttachments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
