<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JunkEntry StructType
 * @subpackage Structs
 */
class JunkEntry extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The match
     * @var string
     */
    public $match;
    /**
     * The matchType
     * @var string
     */
    public $matchType;
    /**
     * The listType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $listType;
    /**
     * The useCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $useCount;
    /**
     * The lastUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastUsed;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:version
     * @var int
     */
    public $version;
    /**
     * The modified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:modified
     * @var string
     */
    public $modified;
    /**
     * Constructor method for JunkEntry
     * @uses JunkEntry::setId()
     * @uses JunkEntry::setMatch()
     * @uses JunkEntry::setMatchType()
     * @uses JunkEntry::setListType()
     * @uses JunkEntry::setUseCount()
     * @uses JunkEntry::setLastUsed()
     * @uses JunkEntry::setVersion()
     * @uses JunkEntry::setModified()
     * @param string $id
     * @param string $match
     * @param string $matchType
     * @param string $listType
     * @param int $useCount
     * @param string $lastUsed
     * @param int $version
     * @param string $modified
     */
    public function __construct($id = null, $match = null, $matchType = null, $listType = null, $useCount = null, $lastUsed = null, $version = null, $modified = null)
    {
        $this
            ->setId($id)
            ->setMatch($match)
            ->setMatchType($matchType)
            ->setListType($listType)
            ->setUseCount($useCount)
            ->setLastUsed($lastUsed)
            ->setVersion($version)
            ->setModified($modified);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\JunkEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get match value
     * @return string|null
     */
    public function getMatch()
    {
        return $this->match;
    }
    /**
     * Set match value
     * @param string $match
     * @return \StructType\JunkEntry
     */
    public function setMatch($match = null)
    {
        // validation for constraint: string
        if (!is_null($match) && !is_string($match)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($match)), __LINE__);
        }
        $this->match = $match;
        return $this;
    }
    /**
     * Get matchType value
     * @return string|null
     */
    public function getMatchType()
    {
        return $this->matchType;
    }
    /**
     * Set matchType value
     * @uses \EnumType\JunkMatchType::valueIsValid()
     * @uses \EnumType\JunkMatchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matchType
     * @return \StructType\JunkEntry
     */
    public function setMatchType($matchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JunkMatchType::valueIsValid($matchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $matchType, implode(', ', \EnumType\JunkMatchType::getValidValues())), __LINE__);
        }
        $this->matchType = $matchType;
        return $this;
    }
    /**
     * Get listType value
     * @return string|null
     */
    public function getListType()
    {
        return $this->listType;
    }
    /**
     * Set listType value
     * @uses \EnumType\JunkHandlingListType::valueIsValid()
     * @uses \EnumType\JunkHandlingListType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $listType
     * @return \StructType\JunkEntry
     */
    public function setListType($listType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JunkHandlingListType::valueIsValid($listType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $listType, implode(', ', \EnumType\JunkHandlingListType::getValidValues())), __LINE__);
        }
        $this->listType = $listType;
        return $this;
    }
    /**
     * Get useCount value
     * @return int|null
     */
    public function getUseCount()
    {
        return $this->useCount;
    }
    /**
     * Set useCount value
     * @param int $useCount
     * @return \StructType\JunkEntry
     */
    public function setUseCount($useCount = null)
    {
        // validation for constraint: int
        if (!is_null($useCount) && !is_numeric($useCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($useCount)), __LINE__);
        }
        $this->useCount = $useCount;
        return $this;
    }
    /**
     * Get lastUsed value
     * @return string|null
     */
    public function getLastUsed()
    {
        return $this->lastUsed;
    }
    /**
     * Set lastUsed value
     * @param string $lastUsed
     * @return \StructType\JunkEntry
     */
    public function setLastUsed($lastUsed = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsed) && !is_string($lastUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUsed)), __LINE__);
        }
        $this->lastUsed = $lastUsed;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\JunkEntry
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get modified value
     * @return string|null
     */
    public function getModified()
    {
        return $this->modified;
    }
    /**
     * Set modified value
     * @param string $modified
     * @return \StructType\JunkEntry
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->modified = $modified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JunkEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
