<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemThreading StructType
 * @subpackage Structs
 */
class ItemThreading extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parent;
    /**
     * Constructor method for ItemThreading
     * @uses ItemThreading::setId()
     * @uses ItemThreading::setParent()
     * @param string $id
     * @param string $parent
     */
    public function __construct($id = null, $parent = null)
    {
        $this
            ->setId($id)
            ->setParent($parent);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ItemThreading
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get parent value
     * @return string|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param string $parent
     * @return \StructType\ItemThreading
     */
    public function setParent($parent = null)
    {
        // validation for constraint: string
        if (!is_null($parent) && !is_string($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent)), __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemThreading
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
