<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemRef StructType
 * @subpackage Structs
 */
class ItemRef extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The uid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $uid;
    /**
     * Constructor method for ItemRef
     * @uses ItemRef::set_()
     * @uses ItemRef::setUid()
     * @param string $_
     * @param string $uid
     */
    public function __construct($_ = null, $uid = null)
    {
        $this
            ->set_($_)
            ->setUid($uid);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ItemRef
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get uid value
     * @return string|null
     */
    public function getUid()
    {
        return $this->uid;
    }
    /**
     * Set uid value
     * @param string $uid
     * @return \StructType\ItemRef
     */
    public function setUid($uid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uid) && !preg_match('/[^@]+(@*)?/', $uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($uid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uid) && !is_string($uid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uid)), __LINE__);
        }
        $this->uid = $uid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
