<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemOptions StructType
 * @subpackage Structs
 */
class ItemOptions extends AbstractStructBase
{
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The expires
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expires;
    /**
     * The delayDeliveryUntil
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $delayDeliveryUntil;
    /**
     * The concealSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $concealSubject;
    /**
     * The hidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hidden;
    /**
     * Constructor method for ItemOptions
     * @uses ItemOptions::setPriority()
     * @uses ItemOptions::setExpires()
     * @uses ItemOptions::setDelayDeliveryUntil()
     * @uses ItemOptions::setConcealSubject()
     * @uses ItemOptions::setHidden()
     * @param string $priority
     * @param string $expires
     * @param string $delayDeliveryUntil
     * @param bool $concealSubject
     * @param bool $hidden
     */
    public function __construct($priority = null, $expires = null, $delayDeliveryUntil = null, $concealSubject = null, $hidden = null)
    {
        $this
            ->setPriority($priority)
            ->setExpires($expires)
            ->setDelayDeliveryUntil($delayDeliveryUntil)
            ->setConcealSubject($concealSubject)
            ->setHidden($hidden);
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\ItemOptionsPriority::valueIsValid()
     * @uses \EnumType\ItemOptionsPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\ItemOptions
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOptionsPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\ItemOptionsPriority::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get expires value
     * @return string|null
     */
    public function getExpires()
    {
        return $this->expires;
    }
    /**
     * Set expires value
     * @param string $expires
     * @return \StructType\ItemOptions
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expires)), __LINE__);
        }
        $this->expires = $expires;
        return $this;
    }
    /**
     * Get delayDeliveryUntil value
     * @return string|null
     */
    public function getDelayDeliveryUntil()
    {
        return $this->delayDeliveryUntil;
    }
    /**
     * Set delayDeliveryUntil value
     * @param string $delayDeliveryUntil
     * @return \StructType\ItemOptions
     */
    public function setDelayDeliveryUntil($delayDeliveryUntil = null)
    {
        // validation for constraint: string
        if (!is_null($delayDeliveryUntil) && !is_string($delayDeliveryUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delayDeliveryUntil)), __LINE__);
        }
        $this->delayDeliveryUntil = $delayDeliveryUntil;
        return $this;
    }
    /**
     * Get concealSubject value
     * @return bool|null
     */
    public function getConcealSubject()
    {
        return $this->concealSubject;
    }
    /**
     * Set concealSubject value
     * @param bool $concealSubject
     * @return \StructType\ItemOptions
     */
    public function setConcealSubject($concealSubject = null)
    {
        // validation for constraint: boolean
        if (!is_null($concealSubject) && !is_bool($concealSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($concealSubject)), __LINE__);
        }
        $this->concealSubject = $concealSubject;
        return $this;
    }
    /**
     * Get hidden value
     * @return bool|null
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    /**
     * Set hidden value
     * @param bool $hidden
     * @return \StructType\ItemOptions
     */
    public function setHidden($hidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($hidden) && !is_bool($hidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hidden)), __LINE__);
        }
        $this->hidden = $hidden;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
