<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IMAP StructType
 * @subpackage Structs
 */
class IMAP extends Account
{
    /**
     * The folder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $folder;
    /**
     * The inbound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Server
     */
    public $inbound;
    /**
     * The outbound
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Server
     */
    public $outbound;
    /**
     * Constructor method for IMAP
     * @uses IMAP::setFolder()
     * @uses IMAP::setInbound()
     * @uses IMAP::setOutbound()
     * @param string $folder
     * @param \StructType\Server $inbound
     * @param \StructType\Server $outbound
     */
    public function __construct($folder = null, \StructType\Server $inbound = null, \StructType\Server $outbound = null)
    {
        $this
            ->setFolder($folder)
            ->setInbound($inbound)
            ->setOutbound($outbound);
    }
    /**
     * Get folder value
     * @return string
     */
    public function getFolder()
    {
        return $this->folder;
    }
    /**
     * Set folder value
     * @param string $folder
     * @return \StructType\IMAP
     */
    public function setFolder($folder = null)
    {
        // validation for constraint: pattern
        if (is_scalar($folder) && !preg_match('/[^@]+(@*)?/', $folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($folder, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($folder) && !is_string($folder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($folder)), __LINE__);
        }
        $this->folder = $folder;
        return $this;
    }
    /**
     * Get inbound value
     * @return \StructType\Server|null
     */
    public function getInbound()
    {
        return $this->inbound;
    }
    /**
     * Set inbound value
     * @param \StructType\Server $inbound
     * @return \StructType\IMAP
     */
    public function setInbound(\StructType\Server $inbound = null)
    {
        $this->inbound = $inbound;
        return $this;
    }
    /**
     * Get outbound value
     * @return \StructType\Server|null
     */
    public function getOutbound()
    {
        return $this->outbound;
    }
    /**
     * Set outbound value
     * @param \StructType\Server $outbound
     * @return \StructType\IMAP
     */
    public function setOutbound(\StructType\Server $outbound = null)
    {
        $this->outbound = $outbound;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IMAP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
