<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Group StructType
 * @subpackage Structs
 */
class Group extends AddressBookItem
{
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GroupMemberList
     */
    public $members;
    /**
     * Constructor method for Group
     * @uses Group::setEmail()
     * @uses Group::setMembers()
     * @param string $email
     * @param \StructType\GroupMemberList $members
     */
    public function __construct($email = null, \StructType\GroupMemberList $members = null)
    {
        $this
            ->setEmail($email)
            ->setMembers($members);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Group
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\GroupMemberList|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\GroupMemberList $members
     * @return \StructType\Group
     */
    public function setMembers(\StructType\GroupMemberList $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Group
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
