<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getQuickMessagesRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: This method provides a quicker access to mail items. It does this by only access fields that are stored in the database index. The fields in the index are: id, status, modified, container, message type, categories, subject,
 * orignalSubject, and source. The New list is the fastest access. The Modified list is slower. The All list is the slowest. If you pass a startDate, the test is for any item that is newer or equal to that date. If you don't pass a container string. The
 * query will be across all folders. If you don't pass a types list, the query will be for all message types unless the container is the Calendar folder. In that case the default will be "CalendarItem. "CalendarItem" is a special case it represents
 * Appointment, Note and Task. You can select the source types you want to see. If you don't specify a source, you will get received, draft and personal. If you don't specify a view, the above fields will be returned. If you specify other fields than
 * the above fields, they will not be returned. You can restrict the number of items return by specifying a count. All items will be returned if no count is given. In the case of searching for items, the new startDate will be returned for use in the
 * next call to getQuickMessagesRequest. The startDate is the time value before this read was performed.
 * @subpackage Structs
 */
class GetQuickMessagesRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The list
     * @var string
     */
    public $list;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: types:startDate
     * @var string
     */
    public $startDate;
    /**
     * The types
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $types;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - default: -1
     * @var int
     */
    public $count;
    /**
     * Constructor method for getQuickMessagesRequest
     * @uses GetQuickMessagesRequest::setContainer()
     * @uses GetQuickMessagesRequest::setList()
     * @uses GetQuickMessagesRequest::setStartDate()
     * @uses GetQuickMessagesRequest::setTypes()
     * @uses GetQuickMessagesRequest::setSource()
     * @uses GetQuickMessagesRequest::setView()
     * @uses GetQuickMessagesRequest::setCount()
     * @param string $container
     * @param string $list
     * @param string $startDate
     * @param string $types
     * @param string $source
     * @param string $view
     * @param int $count
     */
    public function __construct($container = null, $list = null, $startDate = null, $types = null, $source = null, $view = null, $count = -1)
    {
        $this
            ->setContainer($container)
            ->setList($list)
            ->setStartDate($startDate)
            ->setTypes($types)
            ->setSource($source)
            ->setView($view)
            ->setCount($count);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get list value
     * @return string|null
     */
    public function getList()
    {
        return $this->list;
    }
    /**
     * Set list value
     * @uses \EnumType\MessageList::valueIsValid()
     * @uses \EnumType\MessageList::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $list
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setList($list = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageList::valueIsValid($list)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $list, implode(', ', \EnumType\MessageList::getValidValues())), __LINE__);
        }
        $this->list = $list;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get types value
     * @return string|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @param string $types
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setTypes($types = null)
    {
        // validation for constraint: string
        if (!is_null($types) && !is_string($types)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($types)), __LINE__);
        }
        $this->types = $types;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetQuickMessagesRequest
     */
    public function setCount($count = -1)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetQuickMessagesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
