<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMemberOfRequest StructType
 * @subpackage Structs
 */
class GetMemberOfRequest extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The postOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postOffice;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * Constructor method for getMemberOfRequest
     * @uses GetMemberOfRequest::setUserid()
     * @uses GetMemberOfRequest::setPostOffice()
     * @uses GetMemberOfRequest::setDomain()
     * @param string $userid
     * @param string $postOffice
     * @param string $domain
     */
    public function __construct($userid = null, $postOffice = null, $domain = null)
    {
        $this
            ->setUserid($userid)
            ->setPostOffice($postOffice)
            ->setDomain($domain);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\GetMemberOfRequest
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return \StructType\GetMemberOfRequest
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\GetMemberOfRequest
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMemberOfRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
