<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLibraryItemRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: This method will get a library, document or version object depending on the arguments passed in. versionNumber is a string. It can take "current", "official" or a specific version number. To get a version object, you must also supply
 * a document number.
 * @subpackage Structs
 */
class GetLibraryItemRequest extends AbstractStructBase
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $library;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $documentNumber;
    /**
     * The versionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $versionNumber;
    /**
     * Constructor method for getLibraryItemRequest
     * @uses GetLibraryItemRequest::setLibrary()
     * @uses GetLibraryItemRequest::setDocumentNumber()
     * @uses GetLibraryItemRequest::setVersionNumber()
     * @param string $library
     * @param int $documentNumber
     * @param string $versionNumber
     */
    public function __construct($library = null, $documentNumber = null, $versionNumber = null)
    {
        $this
            ->setLibrary($library)
            ->setDocumentNumber($documentNumber)
            ->setVersionNumber($versionNumber);
    }
    /**
     * Get library value
     * @return string|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param string $library
     * @return \StructType\GetLibraryItemRequest
     */
    public function setLibrary($library = null)
    {
        // validation for constraint: pattern
        if (is_scalar($library) && !preg_match('/[^@]+(@*)?/', $library)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($library, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($library) && !is_string($library)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($library)), __LINE__);
        }
        $this->library = $library;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return int|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param int $documentNumber
     * @return \StructType\GetLibraryItemRequest
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($documentNumber) && !is_numeric($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get versionNumber value
     * @return string|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param string $versionNumber
     * @return \StructType\GetLibraryItemRequest
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($versionNumber) && !is_string($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLibraryItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
