<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFolderRequest StructType
 * @subpackage Structs
 */
class GetFolderRequest extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The types
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $types;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * Constructor method for getFolderRequest
     * @uses GetFolderRequest::setId()
     * @uses GetFolderRequest::setFolderType()
     * @uses GetFolderRequest::setTypes()
     * @uses GetFolderRequest::setSource()
     * @uses GetFolderRequest::setView()
     * @param string $id
     * @param string $folderType
     * @param string $types
     * @param string $source
     * @param string $view
     */
    public function __construct($id = null, $folderType = null, $types = null, $source = null, $view = null)
    {
        $this
            ->setId($id)
            ->setFolderType($folderType)
            ->setTypes($types)
            ->setSource($source)
            ->setView($view);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetFolderRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderType::valueIsValid()
     * @uses \EnumType\FolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\GetFolderRequest
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\FolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get types value
     * @return string|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @param string $types
     * @return \StructType\GetFolderRequest
     */
    public function setTypes($types = null)
    {
        // validation for constraint: string
        if (!is_null($types) && !is_string($types)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($types)), __LINE__);
        }
        $this->types = $types;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\GetFolderRequest
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\GetFolderRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFolderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
